/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elect.impl.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.elect.Node;
import kd.bos.elect.impl.CompeteElector;
import kd.bos.instance.Instance;
import kd.bos.instance.LivingLookout;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.NetAddressUtils;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisCompeteElectorImpl
extends CompeteElector {
    private static final String NX = "NX";
    private static final String EX = "EX";
    private volatile boolean masterFlag = false;
    private AtomicLong lease = new AtomicLong();
    private AtomicLong periodForNodesMonitor = new AtomicLong();
    private ExecutorService pool;
    private static final Log log = LogFactory.getLog(RedisCompeteElectorImpl.class);
    Timer timer;
    private static final String SPLITKEY = "#@#";
    private static String INSTANCEANDHOSTVALUE;

    public RedisCompeteElectorImpl(String systemName) {
        super(systemName);
    }

    public RedisCompeteElectorImpl(String systemName, int heartbeatIntervalSeconds) {
        super(systemName, heartbeatIntervalSeconds);
    }

    protected JedisClient createJedisClient() {
        return RedisFactory.getJedisClient((String)this.getRedisUrl());
    }

    private String getRedisUrl() {
        String url = null;
        String useRegion = "elect";
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)useRegion);
        url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionableConfigKey();
            url = System.getProperty(configKey);
        }
        return url;
    }

    @Override
    protected void doStart() {
        this.timer = new Timer("RedisCompeteElector-" + this.getElectClusterName());
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    RedisCompeteElectorImpl.this.doElect();
                }
                catch (Error | Exception e) {
                    log.warn("doElect error", e);
                }
                if (RedisCompeteElectorImpl.this.periodForNodesMonitor.getAndIncrement() % 10L == 0L) {
                    if (RedisCompeteElectorImpl.this.pool == null) {
                        RedisCompeteElectorImpl.this.pool = Executors.newFixedThreadPool(1, new ThreadFactory(){

                            @Override
                            public Thread newThread(@NotNull Runnable r) {
                                return new Thread(r, "RedisCompeteElector-" + RedisCompeteElectorImpl.this.getElectClusterName());
                            }
                        });
                    }
                    RedisCompeteElectorImpl.this.pool.submit(() -> RedisCompeteElectorImpl.this.doWatchElectNodes());
                }
            }
        }, 1L, (long)(this.getHeartbeatIntervalSeconds() * 1000));
        try (JedisClient jedis = this.createJedisClient();){
            jedis.sadd(this.electNodesKey, new String[]{INSTANCEANDHOSTVALUE});
            jedis.expire(this.electNodesKey, 86400L);
        }
    }

    private void doWatchElectNodes() {
        if (!this.isMaster()) {
            return;
        }
        Set nodes = null;
        try (JedisClient jedis = this.createJedisClient();){
            jedis.expire(this.electNodesKey, 86400L);
            nodes = jedis.smembers(this.electNodesKey);
        }
        nodes.forEach(node -> {
            block14: {
                try {
                    String instanceid = this.getInstanceIdFromNodeString((String)node);
                    if (instanceid == null || LivingLookout.isInstanceAlive((String)instanceid)) break block14;
                    this.notifyNodeLost(instanceid);
                    try (JedisClient jedis = this.createJedisClient();){
                        jedis.srem(this.electNodesKey, new String[]{node});
                    }
                }
                catch (Error | Exception e) {
                    log.warn(this.electNodesKey + " doWatchElectNodes error", e);
                }
            }
        });
    }

    private String getInstanceIdFromNodeString(String node) {
        String[] nodeInfos = node.split(SPLITKEY);
        if (nodeInfos.length == 2) {
            return nodeInfos[1];
        }
        if (nodeInfos.length == 1) {
            return nodeInfos[0];
        }
        return null;
    }

    @Override
    protected void doClose() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void doElect() {
        block25: {
            if (Instance.isPausedServiceByMonitor()) {
                if (this.masterFlag) {
                    this.lostMaster();
                }
                return;
            }
            try (JedisClient jedis = this.createJedisClient();){
                if (this.masterFlag) {
                    if (this.lease.get() < System.currentTimeMillis()) {
                        this.lostMaster();
                    } else if (1L == jedis.expire(this.masterKey, this.getHeartbeatTimeOutSeconds())) {
                        if (this.lease.get() < System.currentTimeMillis() || !INSTANCEANDHOSTVALUE.equals(jedis.get(this.masterKey))) {
                            this.lostMaster();
                        } else {
                            this.setLease();
                            if (Boolean.getBoolean("bos.elect.log.enable")) {
                                log.info(this.masterKey + ", masterNodeIs :" + INSTANCEANDHOSTVALUE);
                            }
                        }
                    }
                } else {
                    String status = jedis.set(this.masterKey, INSTANCEANDHOSTVALUE, NX, EX, (long)this.getHeartbeatTimeOutSeconds());
                    if ("OK".equals(status)) {
                        this.becomeMaster();
                    }
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null || !this.masterFlag || !(cause instanceof JedisConnectionException)) break block25;
                this.setLease();
            }
        }
    }

    private void setLease() {
        this.lease.set(System.currentTimeMillis() + (long)(this.getHeartbeatTimeOutSeconds() * 1000));
    }

    private void lostMaster() {
        this.masterFlag = false;
        this.notifyLostMaster();
    }

    private void becomeMaster() {
        this.masterFlag = true;
        this.setLease();
        this.notifyMaster();
    }

    @Override
    public boolean isMaster() {
        this.checkStarted();
        if (this.lease.get() < System.currentTimeMillis()) {
            this.doElect();
        }
        return this.masterFlag;
    }

    @Override
    public Node getMaster() {
        try (JedisClient jedis = this.createJedisClient();){
            String master = jedis.get(this.masterKey);
            Node node = RedisCompeteElectorImpl.parseNode(master);
            return node;
        }
    }

    @NotNull
    private static Node parseNode(String nodeString) {
        String[] masterInfos;
        Node node = new Node();
        if (nodeString != null && (masterInfos = nodeString.split(SPLITKEY)).length == 2) {
            node.setHost(masterInfos[0]);
            node.setInstanceId(masterInfos[1]);
        }
        return node;
    }

    @Override
    public List<Node> getNodes() {
        try (JedisClient jedis = this.createJedisClient();){
            ArrayList<Node> result = new ArrayList<Node>();
            Set nodes = jedis.smembers(this.electNodesKey);
            for (String each : nodes) {
                Node node = RedisCompeteElectorImpl.parseNode(each);
                try {
                    if (node.getInstanceId() == null || !LivingLookout.isInstanceAlive((String)node.getInstanceId())) continue;
                    result.add(RedisCompeteElectorImpl.parseNode(each));
                }
                catch (Exception e) {
                    log.warn("Error occurred when check instance alive: " + node.getInstanceId(), (Throwable)e);
                }
            }
            ArrayList<Node> arrayList = result;
            return arrayList;
        }
    }

    static {
        try {
            INSTANCEANDHOSTVALUE = NetAddressUtils.getLocalIpAddress() + SPLITKEY + Instance.getInstanceId();
        }
        catch (Error | Exception e) {
            INSTANCEANDHOSTVALUE = SPLITKEY + Instance.getInstanceId();
        }
    }
}

