/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.io.StringReader;
import kd.bos.cup.Symbol;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.formula.excel.Lexer;
import kd.bos.formula.excel.parser;
import kd.bos.util.resource.Resources;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.log4j.Logger;

@SdkPublic
public class ExprParser {
    private static Logger logger = Logger.getLogger(ExprParser.class);
    private static final String PROJECT_NAME = "bos-formula";

    public static Expr parse(String formula) throws FormulaException {
        if (formula == null) {
            throw new FormulaException("formula is null.");
        }
        StringReader reader = new StringReader(formula);
        Lexer lexer = new Lexer(reader);
        parser p = new parser(lexer);
        Symbol parse_tree = null;
        try {
            parse_tree = p.parse();
        }
        catch (Exception e) {
            throw new FormulaException("parse error:" + formula, e);
        }
        Expr expr = (Expr)parse_tree.value;
        return expr;
    }

    @SdkInternal
    public static void report_error(String message, Object info) {
        if (info instanceof Symbol && ((Symbol)info).left != -1) {
            logger.debug((Object)("\n\u5728\u7b2c" + ((Symbol)info).left + "\u4e2a\u5b57\u7b26"));
        }
    }

    @SdkInternal
    public static void report_fatal_error(String message, Object info) {
        StringBuilder err = new StringBuilder(Resources.getString((String)"\u8bed\u6cd5\u9519\u8bef:", (String)"ExprParser_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        err.append(message);
        if (info instanceof Symbol) {
            if (((Symbol)info).left != -1) {
                err.append("\n");
                err.append(String.format(Resources.getString((String)"\u5728\u7b2c%s\u4e2a\u5b57\u7b26", (String)"ExprParser_5", (String)PROJECT_NAME, (Object[])new Object[0]), ((Symbol)info).left));
            } else if (((Symbol)info).value == null) {
                err.append("\n");
                err.append(Resources.getString((String)"\u8bed\u53e5\u672a\u6b63\u5e38\u7ed3\u675f\uff0c\u53ef\u80fd\u662f\u7f3a\u5c11\u201c)\u201d\u6216\u201c]\u201d\u7b49\u5339\u914d\u7b26\u53f7\u3002", (String)"ExprParser_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            } else {
                err.append("\n");
                err.append(Resources.getString((String)"\u65e0\u6548\u7b26\u53f7", (String)"ExprParser_4", (String)PROJECT_NAME, (Object[])new Object[0])).append("\"").append(((Symbol)info).value).append("\"");
            }
        } else {
            err.append("\n").append(info.toString());
        }
        throw new FormulaException(err.toString());
    }
}

