/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import kd.bos.formula.excel.FormulaException;
import kd.bos.util.resource.Resources;

public class KDNumber {
    private static final String EXCEPTION_MESSAGE = "num can't be null";
    private static final String PROJECT_NAME = "bos-formula";
    private Number number;

    private static String getDesc() {
        return Resources.getString((String)"\u5b58\u5728\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u7b26\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KDNumber_1", (String)PROJECT_NAME, (Object[])new Object[0]);
    }

    public KDNumber() {
        this(0);
    }

    public KDNumber(Number num) {
        this.number = num;
    }

    public Number getValue() {
        return this.number;
    }

    public static Number sum(Object[] nums) {
        if (nums.length < 1) {
            return 0;
        }
        KDNumber num = new KDNumber(0);
        for (int i = 0; i < nums.length; ++i) {
            num.add((Number)nums[i]);
        }
        return num.number;
    }

    public static Number avg(Object[] nums) {
        if (nums.length < 1) {
            return 0;
        }
        return new KDNumber((Number)KDNumber.sum((Object[])nums)).divide((Number)Integer.valueOf((int)nums.length)).number;
    }

    public static Number max(Object[] nums) {
        if (nums.length < 1) {
            return null;
        }
        KDNumber max_num = null;
        for (int i = 0; i < nums.length; ++i) {
            if (nums[i] == null) continue;
            if (max_num == null) {
                max_num = new KDNumber((Number)nums[i]);
                continue;
            }
            KDNumber num = new KDNumber((Number)nums[i]);
            if (max_num.compareTo(num) >= 0) continue;
            max_num = num;
        }
        if (max_num == null) {
            return null;
        }
        return max_num.getValue();
    }

    public static Number min(Object[] nums) {
        if (nums.length < 1) {
            return null;
        }
        KDNumber min_num = null;
        for (int i = 0; i < nums.length; ++i) {
            if (nums[i] == null) continue;
            if (min_num == null) {
                min_num = new KDNumber((Number)nums[i]);
                continue;
            }
            KDNumber num = new KDNumber((Number)nums[i]);
            if (min_num.compareTo(num) <= 0) continue;
            min_num = num;
        }
        if (min_num == null) {
            return null;
        }
        return min_num.getValue();
    }

    public KDNumber add(Number num) {
        if (num != null) {
            this.number = this.operate(num, Operator.ADD);
        }
        return this;
    }

    public KDNumber subtract(Number num) {
        if (num != null) {
            this.number = this.operate(num, Operator.DIFF);
        }
        return this;
    }

    public KDNumber multiply(Number num) {
        if (num == null) {
            throw new RuntimeException(EXCEPTION_MESSAGE);
        }
        this.number = this.operate(num, Operator.MUL);
        return this;
    }

    public KDNumber divide(Number num) {
        if (num == null) {
            throw new RuntimeException(EXCEPTION_MESSAGE);
        }
        this.number = this.operate(num, Operator.DIVIDE);
        return this;
    }

    Number operate(Number num, Operator op) {
        if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(this.number);
            BigDecimal b = this.toDecimal(num);
            return this.operate_decimal(a, b, op);
        }
        if (this.isFloat(num) || this.isFloat(this.number)) {
            return this.operate_double(this.number.doubleValue(), num.doubleValue(), op);
        }
        if (this.isLong(num) || this.isLong(this.number)) {
            return this.operate_long(this.number.longValue(), num.longValue(), op);
        }
        if (num instanceof Integer) {
            return this.operate_integer(this.number.intValue(), num.intValue(), op);
        }
        throw new RuntimeException("not supported");
    }

    Integer operate_integer(Integer a, Integer b, Operator op) {
        switch (op) {
            case ADD: {
                return a + b;
            }
            case DIFF: {
                return a - b;
            }
            case MUL: {
                return a * b;
            }
            case DIVIDE: {
                return a / b;
            }
        }
        throw new RuntimeException(KDNumber.getDesc() + (Object)((Object)op));
    }

    Long operate_long(Long a, Long b, Operator op) {
        switch (op) {
            case ADD: {
                return a + b;
            }
            case DIFF: {
                return a - b;
            }
            case MUL: {
                return a * b;
            }
            case DIVIDE: {
                return a / b;
            }
        }
        throw new RuntimeException(KDNumber.getDesc() + (Object)((Object)op));
    }

    Double operate_double(Double a, Double b, Operator op) {
        switch (op) {
            case ADD: {
                return a + b;
            }
            case DIFF: {
                return a - b;
            }
            case MUL: {
                return a * b;
            }
            case DIVIDE: {
                return a / b;
            }
        }
        throw new RuntimeException(KDNumber.getDesc() + (Object)((Object)op));
    }

    Number operate_decimal(BigDecimal a, BigDecimal b, Operator op) {
        switch (op) {
            case ADD: {
                return a.add(b);
            }
            case DIFF: {
                return a.subtract(b);
            }
            case MUL: {
                return a.multiply(b);
            }
            case DIVIDE: {
                return a.divide(b, 10, RoundingMode.HALF_UP);
            }
        }
        throw new RuntimeException(KDNumber.getDesc() + (Object)((Object)op));
    }

    boolean isFloat(Number num) {
        return num instanceof Float || num instanceof Double;
    }

    boolean isLong(Number num) {
        return num instanceof Long || num instanceof BigInteger;
    }

    BigDecimal toDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof Integer || n instanceof BigInteger || n instanceof Long) {
            return new BigDecimal(n.longValue());
        }
        if (n instanceof Double) {
            return BigDecimal.valueOf(n.doubleValue());
        }
        throw new FormulaException(Resources.getString((String)"\u5b58\u5728\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KDNumber_2", (String)PROJECT_NAME, (Object[])new Object[0]) + n.getClass());
    }

    public int compareTo(KDNumber num) {
        return this.compareTo(num.getValue());
    }

    public int compareTo(Number num) {
        if (num == null || this.number == null) {
            throw new RuntimeException(EXCEPTION_MESSAGE);
        }
        if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(num);
            BigDecimal b = this.toDecimal(this.number);
            return b.compareTo(a);
        }
        if (this.isFloat(num) || this.isFloat(this.number)) {
            return Double.compare(this.number.doubleValue(), num.doubleValue());
        }
        if (num instanceof Long || num instanceof BigInteger || this.number instanceof Long) {
            return Long.compare(this.number.longValue(), num.longValue());
        }
        if (num instanceof Integer) {
            return Integer.compare(this.number.intValue(), num.intValue());
        }
        throw new RuntimeException("not supported");
    }

    public static void main(String[] args) {
        Object[] items = new Object[]{1, new BigDecimal("1.23"), 1232, new BigDecimal("0.1111"), new BigDecimal("0.0000001")};
        Object[] paras = new Object[]{items};
    }

    static enum Operator {
        ADD,
        DIFF,
        MUL,
        DIVIDE;

    }
}

