/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.util.HashMap;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.ExprBase;
import kd.bos.formula.excel.Visitor;

public class Macro
extends ExprBase {
    private String name;
    private static HashMap<String, Executor> executorMap = new HashMap();

    public Macro(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Object execute(ExecuteContext context) {
        return Macro.getExecutor(this.name).execute(context);
    }

    @Override
    public void accept(Visitor vistor) {
        vistor.visit(this);
    }

    private static void registerExecutor(String name, Executor executor) {
        executorMap.put(name.toUpperCase(), executor);
    }

    private static Executor getExecutor(String name) {
        return executorMap.get(name);
    }

    public static boolean isMacro(String name) {
        return name == null ? false : executorMap.containsKey(name.toUpperCase());
    }

    static {
        Macro.registerExecutor("TRUE", context -> Boolean.TRUE);
        Macro.registerExecutor("FALSE", context -> Boolean.FALSE);
        Macro.registerExecutor("NULL", context -> null);
    }

    private static interface Executor {
        public Object execute(ExecuteContext var1);
    }
}

