/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.math.BigDecimal;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.formula.excel.KDNumber;
import kd.bos.util.resource.Resources;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class Operator {
    private static final String PROJECT_NAME = "bos-formula";
    public static final Operator AND = new Operator("and"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            if (left instanceof Boolean && !((Boolean)left).booleanValue()) {
                return false;
            }
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return (Boolean)left != false && (Boolean)right != false;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201cand\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61\u3002", (String)"Operator_0", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator OR = new Operator("or"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            if (left instanceof Boolean && ((Boolean)left).booleanValue()) {
                return true;
            }
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return (Boolean)left != false || (Boolean)right != false;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201cor\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61\u3002", (String)Operator.PROJECT_NAME));
        }
    };
    public static final Operator XOR = new Operator("xor"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left instanceof Boolean && right instanceof Boolean) {
                return ((Boolean)left).booleanValue() != ((Boolean)right).booleanValue();
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201cxor\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61\u3002", (String)"Operator_2", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator NOT = new Operator("not"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object o = params[0].execute(context);
            if (o instanceof Boolean) {
                return (Boolean)o == false;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201cnot\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u903b\u8f91\u5bf9\u8c61\u3002", (String)"Operator_3", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator PLUS = new Operator("+"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            if (left instanceof String) {
                return (String)left + right.toString();
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).add((Number)right).getValue();
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c+\u201d\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u6216\u5b57\u7b26\u4e32\u5bf9\u8c61\u3002", (String)"Operator_4", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator MINUS = new Operator("-"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                left = 0;
            }
            if (right == null) {
                return left;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).subtract((Number)right).getValue();
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c-\u201d\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61\u3002", (String)"Operator_5", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator TIMES = new Operator("*"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null || right == null) {
                return null;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).multiply((Number)right).getValue();
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c*\u201d\u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61\u3002", (String)"Operator_6", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator DIVIDE = new Operator("/"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null || right == null) {
                return null;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).divide((Number)right).getValue();
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c/\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61\u3002", (String)"Operator_7", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator MOD = new Operator("%"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null || right == null) {
                return null;
            }
            if (left instanceof Integer && right instanceof Integer) {
                if ((Integer)right == 0) {
                    return null;
                }
                return (Integer)left % (Integer)right;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c%\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6574\u6570\u5bf9\u8c61\u3002", (String)"Operator_8", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator UMINUS = new Operator("-"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object right = params[0].execute(context);
            if (right == null) {
                return null;
            }
            if (right instanceof Number) {
                if (right instanceof BigDecimal) {
                    return ((BigDecimal)right).multiply(BigDecimal.valueOf(-1L));
                }
                if (right instanceof Double) {
                    return -((Number)right).doubleValue();
                }
                if (right instanceof Long) {
                    return -((Number)right).longValue();
                }
                return -((Number)right).intValue();
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c- \u64cd\u4f5c\u7b26\u9002\u7528\u4e8e\u6570\u5b57\u5bf9\u8c61\u3002", (String)"Operator_5", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator EQ = new Operator("="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null || right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).compareTo((Number)right) == 0;
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                try {
                    return ((Comparable)left).compareTo((Comparable)right) == 0;
                }
                catch (ClassCastException e) {
                    throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c=\u201d \u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6570\u5b57\u6216\u5b57\u7b26\u4e32\u5bf9\u8c61\u3002", (String)"Operator_13", (String)Operator.PROJECT_NAME, (Object[])new Object[0]), e);
                }
            }
            if (left == right) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };
    public static final Operator GT = new Operator(">"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.FALSE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).compareTo((Number)right) > 0;
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo((Comparable)right) > 0;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c>\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6570\u5b57\u548c\u65e5\u671f\u5bf9\u8c61\u3002", (String)"Operator_9", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator GE = new Operator(">="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null) {
                return Boolean.FALSE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).compareTo((Number)right) >= 0;
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo((Comparable)right) >= 0;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c>=\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6570\u5b57\u548c\u65e5\u671f\u5bf9\u8c61\u3002", (String)"Operator_10", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator LT = new Operator("<"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).compareTo((Number)right) < 0;
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo((Comparable)right) < 0;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c<\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6570\u5b57\u548c\u65e5\u671f\u5bf9\u8c61\u3002", (String)"Operator_11", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator LE = new Operator("<="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.TRUE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.FALSE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).compareTo((Number)right) <= 0;
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo((Comparable)right) <= 0;
            }
            throw new FormulaException(Resources.getString((String)"\u6267\u884c\u51fa\u9519\uff0c\u201c<=\u201d\u64cd\u4f5c\u7b26\u4ec5\u9002\u7528\u4e8e\u6570\u5b57\u548c\u65e5\u671f\u5bf9\u8c61\u3002", (String)"Operator_12", (String)Operator.PROJECT_NAME, (Object[])new Object[0]));
        }
    };
    public static final Operator NE = new Operator("<>"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object leftObj = params[0].execute(context);
            Object rightObj = params[1].execute(context);
            if (leftObj == null && rightObj == null) {
                return Boolean.FALSE;
            }
            if (leftObj == null) {
                return Boolean.TRUE;
            }
            if (rightObj == null) {
                return Boolean.TRUE;
            }
            if (leftObj instanceof Number && rightObj instanceof Number) {
                return new KDNumber((Number)leftObj).compareTo((Number)rightObj) != 0;
            }
            if (leftObj instanceof Comparable && rightObj instanceof Comparable) {
                return ((Comparable)leftObj).compareTo((Comparable)rightObj) != 0;
            }
            return !leftObj.equals(rightObj);
        }
    };
    public static final Operator NE2 = new Operator("!="){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return Boolean.FALSE;
            }
            if (left == null) {
                return Boolean.TRUE;
            }
            if (right == null) {
                return Boolean.TRUE;
            }
            if (left instanceof Number && right instanceof Number) {
                return new KDNumber((Number)left).compareTo((Number)right) != 0;
            }
            if (left instanceof Comparable && right instanceof Comparable) {
                return ((Comparable)left).compareTo((Comparable)right) != 0;
            }
            return !left.equals(right);
        }
    };
    public static final Operator IN = new Operator("IN"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object[] values = (Object[])params[1].execute(context);
            for (int i = 0; i < values.length; ++i) {
                if (!Operator.equal(left, values[i])) continue;
                return true;
            }
            return false;
        }
    };
    public static final Operator NOTIN = new Operator("NOT IN"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object[] values = (Object[])params[1].execute(context);
            for (int i = 0; i < values.length; ++i) {
                if (!Operator.equal(left, values[i])) continue;
                return false;
            }
            return true;
        }
    };
    public static final Operator CONCAT = new Operator("&"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            Object left = params[0].execute(context);
            Object right = params[1].execute(context);
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return right.toString();
            }
            if (right == null) {
                return left.toString();
            }
            return left.toString() + right.toString();
        }
    };
    public static final Operator LIKE = new Operator("LIKE"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            return Operator.checkLike(context, params);
        }
    };
    public static final Operator NOTLIKE = new Operator("NOT LIKE"){

        @Override
        public Object execute(ExecuteContext context, Expr[] params) {
            return !Operator.checkLike(context, params);
        }
    };
    private String name;

    private static boolean equal(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (a instanceof Number && b instanceof Number) {
            return new KDNumber((Number)a).compareTo((Number)b) == 0;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b) == 0;
        }
        return a.equals(b);
    }

    private static boolean checkLike(ExecuteContext context, Expr[] params) {
        Object left = params[0].execute(context);
        Object right = params[1].execute(context);
        if (right == null) {
            throw new FormulaException("LIKE can't be null");
        }
        if (!(right instanceof String)) {
            throw new FormulaException("LIKE right must be String");
        }
        if (left == null) {
            return false;
        }
        if (!(left instanceof String)) {
            throw new FormulaException("LIKE left must be String");
        }
        String pattern = right.toString().trim();
        boolean leftLike = false;
        boolean rightLike = false;
        if (pattern.startsWith("%")) {
            leftLike = true;
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("%")) {
            rightLike = true;
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (leftLike && rightLike) {
            return left.toString().contains(pattern);
        }
        if (leftLike) {
            return left.toString().endsWith(pattern);
        }
        if (rightLike) {
            return left.toString().startsWith(pattern);
        }
        return left.equals(pattern);
    }

    private Operator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public abstract Object execute(ExecuteContext var1, Expr[] var2);
}

