/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.assembly;

import java.util.ArrayList;
import java.util.List;
import kd.bos.extension.ExtensionFactory;
import kd.bos.mservice.spi.rpc.MServiceLookup;
import kd.bos.mservice.spi.rpc.MServiceRegister;
import kd.bos.mservice.spi.rpc.MServiceStarter;

public class AssemblyServiceManager {
    private static String[] assemRpcTypes;
    private static final int INSIDEINDEX = 0;
    private static final int OUTSIDEINDEX = 1;
    private static ExtensionFactory<MServiceLookup> lookupFactory;
    private static ExtensionFactory<MServiceRegister> registerFactory;
    private static ExtensionFactory<MServiceStarter> servicestarterFactory;

    static List<MServiceStarter> getServiceStarters() {
        ArrayList<MServiceStarter> serviceStarters = new ArrayList<MServiceStarter>(2);
        for (String rpcType : assemRpcTypes) {
            serviceStarters.add((MServiceStarter)servicestarterFactory.getExtension(rpcType));
        }
        return serviceStarters;
    }

    static List<MServiceRegister> getServiceRegisters() {
        ArrayList<MServiceRegister> serviceRegisters = new ArrayList<MServiceRegister>(2);
        for (String rpcType : assemRpcTypes) {
            serviceRegisters.add((MServiceRegister)registerFactory.getExtension(rpcType));
        }
        return serviceRegisters;
    }

    static MServiceRegister getInsideServiceRegister() {
        String insideRegister = System.getProperty("assemble.rpc.inside", assemRpcTypes[0]);
        return (MServiceRegister)registerFactory.getExtension(insideRegister);
    }

    static MServiceRegister getOutsideServiceRegister() {
        String outsideRegister = System.getProperty("assemble.rpc.outside", assemRpcTypes[1]);
        return (MServiceRegister)registerFactory.getExtension(outsideRegister);
    }

    static MServiceLookup getInsideServiceLookup() {
        String insideLookup = System.getProperty("assemble.rpc.inside", assemRpcTypes[0]);
        return (MServiceLookup)lookupFactory.getExtension(insideLookup);
    }

    static MServiceLookup getOutsideServiceLookup() {
        String outsideLookup = System.getProperty("assemble.rpc.outside", assemRpcTypes[1]);
        return (MServiceLookup)lookupFactory.getExtension(outsideLookup);
    }

    private static void initAssemRpcTypes() {
        String assemRpcType = System.getProperty("assemble.rpc.types", "dubbo,feign");
        assemRpcTypes = assemRpcType.split(",");
    }

    static {
        lookupFactory = ExtensionFactory.getExtensionFacotry(MServiceLookup.class);
        registerFactory = ExtensionFactory.getExtensionFacotry(MServiceRegister.class);
        servicestarterFactory = ExtensionFactory.getExtensionFacotry(MServiceStarter.class);
        AssemblyServiceManager.initAssemRpcTypes();
    }
}

