/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.dom.expr;

import kd.bos.kscript.dom.expr.BinaryOpType;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.parser.Position;

public class BinaryOpExpr
extends CodeExpr {
    public CodeExpr left;
    public CodeExpr right;
    public int operator;
    public Class _class;

    public BinaryOpExpr() {
        this(null);
    }

    public BinaryOpExpr(Position pos) {
        super(pos, 0);
    }

    public BinaryOpExpr(CodeExpr left, int operator, CodeExpr right) {
        this(null, left, operator, right);
    }

    public BinaryOpExpr(Position pos, CodeExpr left, int operator, CodeExpr right) {
        super(pos, 0);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public void output(StringBuffer buff) {
        if (this.left instanceof BinaryOpExpr) {
            BinaryOpExpr left = (BinaryOpExpr)this.left;
            int pl = BinaryOpType.priority(left.operator);
            int pc = BinaryOpType.priority(this.operator);
            if (!(pl <= 0 || pc <= 0 || pl < pc || pc == 5 && pl == 5 || pl == 3 && pc == 2)) {
                this.left.output(buff);
                buff.append(' ');
            } else {
                buff.append('(');
                this.left.output(buff);
                buff.append(") ");
            }
        } else {
            this.left.output(buff);
            buff.append(' ');
        }
        BinaryOpType.output(buff, this.operator);
        if (this.right instanceof BinaryOpExpr) {
            BinaryOpExpr right = (BinaryOpExpr)this.right;
            int pc = BinaryOpType.priority(this.operator);
            int pr = BinaryOpType.priority(right.operator);
            if (pc > 0 && pr > 0 && pr > pc && (pr != 3 || pc != 2) || this.operator == right.operator && BinaryOpType.isAssociative(this.operator)) {
                buff.append(' ');
                this.right.output(buff);
            } else {
                buff.append(" (");
                this.right.output(buff);
                buff.append(')');
            }
        } else {
            buff.append(' ');
            this.right.output(buff);
        }
    }

    @Override
    public final Class getExprClass() {
        return this._class;
    }

    @Override
    public void setExprClass(Class c) {
        this._class = c;
    }
}

