/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.kscript.IObjectLoaderProvider;
import kd.bos.kscript.KScriptException;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.dom.expr.ArrayIndexerExpr;
import kd.bos.kscript.dom.expr.BigDecimalExpr;
import kd.bos.kscript.dom.expr.BinaryOpExpr;
import kd.bos.kscript.dom.expr.BoolExpr;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.dom.expr.DoubleExpr;
import kd.bos.kscript.dom.expr.FloatExpr;
import kd.bos.kscript.dom.expr.IdentifierExpr;
import kd.bos.kscript.dom.expr.IntExpr;
import kd.bos.kscript.dom.expr.LongExpr;
import kd.bos.kscript.dom.expr.MethodInvokeExpr;
import kd.bos.kscript.dom.expr.NullExpr;
import kd.bos.kscript.dom.expr.ObjectCreateExpr;
import kd.bos.kscript.dom.expr.PropertyExpr;
import kd.bos.kscript.dom.expr.StringExpr;
import kd.bos.kscript.dom.expr.UnaryExpr;
import kd.bos.kscript.dom.expr.VectorCreateExpr;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.dom.stmt.ElseIfItem;
import kd.bos.kscript.dom.stmt.ExprStmt;
import kd.bos.kscript.dom.stmt.IfStmt;
import kd.bos.kscript.dom.stmt.ReturnStmt;
import kd.bos.kscript.dom.stmt.VarDeclItem;
import kd.bos.kscript.dom.stmt.VarDeclStmt;
import kd.bos.kscript.exception.TODOException;
import kd.bos.kscript.parser.ExprParser;
import kd.bos.kscript.parser.KScriptParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;
import kd.bos.kscript.runtime.ArrayIterator;
import kd.bos.kscript.runtime.ArrayIterator2;
import kd.bos.kscript.runtime.SingleIterator;

public class KScriptUtil {
    private static IObjectLoaderProvider bizObjectProvider = null;

    public static IObjectLoaderProvider getBizObjectProvider() {
        return bizObjectProvider;
    }

    public static void setBizObjectProvider(IObjectLoaderProvider bizObjectProvider) {
        KScriptUtil.bizObjectProvider = bizObjectProvider;
    }

    public static Boolean isBoolExpr(String script) throws KScriptException {
        Boolean rtnVal = null;
        ExprParser parser = new ExprParser(script);
        CodeExpr expr = parser.expr();
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            switch (binaryOpExpr.operator) {
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 18: {
                    rtnVal = Boolean.TRUE;
                    break;
                }
                default: {
                    rtnVal = Boolean.FALSE;
                }
            }
        }
        return rtnVal;
    }

    public static void computeIdent(String script, Collection identCol) throws KScriptException {
        if (script == null) {
            return;
        }
        KScriptParser parser = new KScriptParser(script);
        parser.parse();
        List stmtList = parser.stmtList;
        int size = stmtList.size();
        for (int i = 0; i < size; ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            KScriptUtil.computeIdent(stmt, identCol);
        }
    }

    public static void computeIdent(CodeStmt stmt, Collection identCol) throws KScriptException {
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            KScriptUtil.computeIdent(expr, identCol);
        } else if (stmt instanceof ReturnStmt) {
            CodeExpr expr = ((ReturnStmt)stmt).expr;
            KScriptUtil.computeIdent(expr, identCol);
        } else if (stmt instanceof VarDeclStmt) {
            VarDeclStmt declStmt = (VarDeclStmt)stmt;
            for (int i = 0; i < declStmt.varDeclList.size(); ++i) {
                VarDeclItem item = (VarDeclItem)declStmt.varDeclList.get(i);
                if (item.initExpr == null) continue;
                KScriptUtil.computeIdent(item.initExpr, identCol);
            }
        } else if (stmt instanceof IfStmt) {
            int i;
            IfStmt ifStmt = (IfStmt)stmt;
            KScriptUtil.computeIdent(ifStmt.testExpr, identCol);
            for (i = 0; i < ifStmt.trueStmtList.size(); ++i) {
                KScriptUtil.computeIdent((CodeStmt)ifStmt.trueStmtList.get(i), identCol);
            }
            if (ifStmt.elseStmtList != null) {
                for (i = 0; i < ifStmt.elseStmtList.size(); ++i) {
                    KScriptUtil.computeIdent((CodeStmt)ifStmt.elseStmtList.get(i), identCol);
                }
            }
            if (ifStmt.elseIfList != null) {
                for (i = 0; i < ifStmt.elseIfList.size(); ++i) {
                    ElseIfItem elseIf = (ElseIfItem)ifStmt.elseIfList.get(i);
                    KScriptUtil.computeIdent(elseIf.testExpr, identCol);
                    if (elseIf.stmtList == null) continue;
                    for (int j = 0; j < elseIf.stmtList.size(); ++j) {
                        KScriptUtil.computeIdent((CodeStmt)elseIf.stmtList.get(j), identCol);
                    }
                }
            }
        } else {
            throw new TODOException();
        }
    }

    public static void computeIdent(CodeExpr expr, Collection identCollection) throws KScriptException {
        if (expr == null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof PropertyExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)expr;
            KScriptUtil.computeIdent(unaryExpr.expr, identCollection);
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            KScriptUtil.computeIdent(binaryOpExpr.left, identCollection);
            KScriptUtil.computeIdent(binaryOpExpr.right, identCollection);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                KScriptUtil.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (CodeExpr pramExpr : objCreateExpr.paramList) {
                KScriptUtil.computeIdent(pramExpr, identCollection);
            }
        } else {
            if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
                return;
            }
            if (expr instanceof ArrayIndexerExpr) {
                ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                KScriptUtil.computeIdent(arrayIndexerExpr.targetObjExpr, identCollection);
                KScriptUtil.computeIdent(arrayIndexerExpr.indexExpr, identCollection);
            } else if (expr instanceof VectorCreateExpr) {
                VectorCreateExpr newVecExpr = (VectorCreateExpr)expr;
                for (int i = 0; i < newVecExpr.paramList.size(); ++i) {
                    CodeExpr pramExpr = (CodeExpr)newVecExpr.paramList.get(i);
                    KScriptUtil.computeIdent(pramExpr, identCollection);
                }
            } else {
                throw new TODOException();
            }
        }
    }

    public static String replaceIdent(String text, String oldString, String newString) throws ParserException {
        String[] textStrings = text.split("\n|\r\n|\r|\n\r");
        StringBuffer resultBuf = new StringBuffer();
        for (int i = 0; i < textStrings.length; ++i) {
            String textStr = textStrings[i];
            Lexer lexer = new Lexer(textStr);
            TokenList tokList = new TokenList(lexer);
            while (!tokList.lookup(0).equals(Token.EOFToken)) {
                Token token = tokList.next();
                if (token.type == 1 && token.value.equals(oldString)) {
                    token.value = newString;
                }
                if (token.type == 6) {
                    resultBuf.append("\"" + token.value + "\" ");
                    continue;
                }
                if (token.type == 7) {
                    resultBuf.append("'" + token.value + "'");
                    continue;
                }
                if (token.type == 0 || token.type == 14) {
                    throw new ParserException("todo.", token, "unsuport LineComment and MultiLineComment token now");
                }
                resultBuf.append(token.value + " ");
            }
            if (textStr.indexOf("//") > -1) {
                String scriptComments = textStr.substring(textStr.indexOf("//"));
                resultBuf.append(scriptComments);
            }
            if (i <= 0) continue;
            resultBuf.append("\n");
        }
        return resultBuf.substring(0, resultBuf.length() - 1);
    }

    public static boolean isCollection(Object obj) {
        if (obj == null) {
            return false;
        }
        return bizObjectProvider != null && bizObjectProvider.isObjectCollection(obj) || obj instanceof Collection || obj instanceof Array || obj.getClass().isArray();
    }

    public static Iterator getIterator(Object obj) {
        if (bizObjectProvider != null && bizObjectProvider.isObjectCollection(obj)) {
            return bizObjectProvider.getObjectCollectionIterator(obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Array) {
            return new ArrayIterator((Array)obj);
        }
        if (obj != null && obj.getClass().isArray()) {
            return new ArrayIterator2(obj);
        }
        return new SingleIterator(obj);
    }

    public static Object evalJavaMethod(Object object, Method method, Object[] params) throws SecurityException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> objCls = method.getDeclaringClass();
        String methodName = method.getName();
        Class<?>[] argCls = method.getParameterTypes();
        try {
            method.setAccessible(true);
            Object o = method.invoke(object, params);
            return o;
        }
        catch (IllegalAccessException o) {
            Class<?>[] inters = objCls.getInterfaces();
            for (int i = 0; i < inters.length; ++i) {
                try {
                    method = inters[i].getMethod(methodName, argCls);
                    Object o2 = method.invoke(object, params);
                    return o2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            while (true) {
                if ((objCls = objCls.getSuperclass()) == null) {
                    throw new IllegalAccessException("Can't find method " + methodName + " in Class " + objCls + " and its super class with modifier public.");
                }
                try {
                    method = objCls.getMethod(methodName, argCls);
                    Object o3 = method.invoke(object, params);
                    return o3;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Method findGetMethod(Class c, String fieldName) {
        Method[] methodArray = c.getMethods();
        String[] methNameArray = Character.isLowerCase(fieldName.charAt(0)) ? new String[]{"get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), fieldName, "get" + fieldName, "get" + fieldName} : new String[]{fieldName, "get" + fieldName, "is" + fieldName};
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getParameterTypes().length != 0) continue;
            for (int j = 0; j < methNameArray.length; ++j) {
                if (!methodArray[i].getName().equals(methNameArray[j])) continue;
                return methodArray[i];
            }
        }
        return null;
    }

    public static Method findSetMethod(Class c, String fieldName) {
        Method[] methodArray = c.getMethods();
        String[] methNameArray = Character.isLowerCase(fieldName.charAt(0)) ? new String[]{"set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), fieldName, "set" + fieldName} : new String[]{fieldName, "set" + fieldName};
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getParameterTypes().length != 1) continue;
            for (int j = 0; j < methNameArray.length; ++j) {
                if (!methodArray[i].getName().equals(methNameArray[j])) continue;
                return methodArray[i];
            }
        }
        return null;
    }

    static {
        try {
            bizObjectProvider = (IObjectLoaderProvider)Class.forName("kd.bos.dao.ormapping.KscriptObjectLoaderProvider").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

