/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kscript.runtime;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

public class ReflectionUtils {
    private static Reference methodCacheRef;
    private static final Class[] PRIMITIVE_CLASSES;

    public static Constructor getConstructor(Class cls, Class[] args) {
        Constructor<?> constructor = null;
        Constructor<?>[] ctors = cls.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            if (!ReflectionUtils.matchArguments(args, ctors[i].getParameterTypes())) continue;
            constructor = ctors[i];
        }
        return constructor;
    }

    public static synchronized Method getMethod(Class targetClass, String methodName, Class[] argClasses) {
        Signature signature = new Signature(targetClass, methodName, argClasses);
        Method method = null;
        HashMap<Signature, Method> methodCache = null;
        if (methodCacheRef != null && (methodCache = (HashMap<Signature, Method>)methodCacheRef.get()) != null && (method = (Method)methodCache.get(signature)) != null) {
            return method;
        }
        method = ReflectionUtils.findMethod(targetClass, methodName, argClasses);
        if (method != null) {
            if (methodCache == null) {
                methodCache = new HashMap<Signature, Method>();
                methodCacheRef = new SoftReference(methodCache);
            }
            methodCache.put(signature, method);
        }
        return method;
    }

    private static boolean matchArguments(Class[] argClasses, Class[] argTypes) {
        boolean match = argClasses.length == argTypes.length;
        for (int j = 0; j < argClasses.length && match; ++j) {
            Class argClass;
            Class argType = ReflectionUtils.typeToClass(argTypes[j]);
            Class clazz = argClass = argClasses[j] == null ? null : ReflectionUtils.typeToClass(argClasses[j]);
            if (argClass == null || ReflectionUtils.isAssignmentCompatible(argType, argClass)) continue;
            match = false;
        }
        return match;
    }

    private static final boolean isAssignmentCompatible(Class parameterType, Class parameterization) {
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        return ReflectionUtils.isPrimitiveCompatible(parameterType, parameterization);
    }

    private static int indexOf(Class clazz) {
        for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
            if (PRIMITIVE_CLASSES[i] != clazz) continue;
            return i;
        }
        return -1;
    }

    private static final boolean isPrimitiveCompatible(Class parameterType, Class parameterization) {
        int typeIndex = ReflectionUtils.indexOf(parameterType);
        int parameterizationIndex = ReflectionUtils.indexOf(parameterization);
        return parameterizationIndex != -1 && typeIndex != -1 && parameterizationIndex <= typeIndex;
    }

    public static Class typeToClass(Class type) {
        if (type == null) {
            return null;
        }
        if (!type.isPrimitive()) {
            return type;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        throw new AssertionError((Object)("Unknown Class Type: " + type.getName()));
    }

    private static boolean matchExplicitArguments(Class[] argClasses, Class[] argTypes) {
        boolean match = argClasses.length == argTypes.length;
        for (int j = 0; j < argClasses.length && match; ++j) {
            if (ReflectionUtils.typeToClass(argClasses[j]) == ReflectionUtils.typeToClass(argTypes[j])) continue;
            match = false;
        }
        return match;
    }

    static Method getPublicMethod(Class declaringClass, String methodName, Class[] argClasses) throws NoSuchMethodException {
        Method m = ReflectionUtils.findPublicMethod(declaringClass, methodName, argClasses);
        if (m == null) {
            throw new NoSuchMethodException(declaringClass.getName() + "." + methodName);
        }
        return m;
    }

    private static Method findPublicMethod(Class declaringClass, String methodName, Class[] argClasses) {
        Method method;
        if (argClasses.length == 0) {
            try {
                return declaringClass.getMethod(methodName, argClasses);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        Method[] methods = declaringClass.getMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!method.getName().equals(methodName) || !ReflectionUtils.matchArguments(argClasses, method.getParameterTypes())) continue;
            list.add(method);
        }
        if (list.size() > 0) {
            if (list.size() == 1) {
                return (Method)list.get(0);
            }
            ListIterator iterator = list.listIterator();
            while (iterator.hasNext()) {
                method = (Method)iterator.next();
                if (!ReflectionUtils.matchExplicitArguments(argClasses, method.getParameterTypes())) continue;
                return method;
            }
            return (Method)list.get(0);
        }
        return null;
    }

    private static Method findMethod(Class targetClass, String methodName, Class[] argClasses) {
        Method m = ReflectionUtils.findPublicMethod(targetClass, methodName, argClasses);
        if (m != null && Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return m;
        }
        for (Class type = targetClass; type != null; type = type.getSuperclass()) {
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                m = ReflectionUtils.findPublicMethod(interfaces[i], methodName, argClasses);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }

    static {
        PRIMITIVE_CLASSES = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    }

    private static class Signature {
        private Class targetClass;
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        public Signature(Class targetClass, String methodName, Class[] argClasses) {
            this.targetClass = targetClass;
            this.methodName = methodName;
            this.argClasses = argClasses;
        }

        public boolean equals(Object o2) {
            if (o2 == null) {
                return false;
            }
            if (!(o2 instanceof Signature)) {
                return false;
            }
            if (this == o2) {
                return true;
            }
            Signature that = (Signature)o2;
            if (this.targetClass != that.targetClass) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (this.argClasses.length != that.argClasses.length) {
                return false;
            }
            for (int i = 0; i < this.argClasses.length; ++i) {
                if (this.argClasses[i] == that.argClasses[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.targetClass.hashCode();
                result = 37 * result + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i = 0; i < this.argClasses.length; ++i) {
                        result = 37 * result + (this.argClasses[i] == null ? 0 : this.argClasses[i].hashCode());
                    }
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }
}

