/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bos.inner;

import java.io.IOException;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.service.KdtxSerializer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.PublisherSupport;

public class MqSerialiazer
implements KdtxSerializer {
    Log logger = LogFactory.getLog(MqSerialiazer.class);

    public void preSerialize(Object data, DtxParas dtxParas) {
        Message message = (Message)data;
        message.setKdtxId(dtxParas.getXid());
        message.setSeq(dtxParas.getSeq());
    }

    public byte[] serialize(Object message) throws IOException {
        int limit;
        byte[] bytes = MessageSerde.get().encode((Message)message);
        if (bytes.length > (limit = PublisherSupport.MQ_MESSAGE_PAYLOAD_VALUE)) {
            String errorMsg = String.format("message body overload,limit %s bytes,actual %s bytes ", limit, bytes.length);
            if (Boolean.parseBoolean(System.getProperty("mq.message.overload.throw", "false"))) {
                throw new KDException(BosErrorCode.mqException, new Object[]{errorMsg});
            }
            this.logger.error("publish0 overload", (Throwable)new KDException(BosErrorCode.mqException, new Object[]{errorMsg}));
        }
        return bytes;
    }

    public Object deserialize(byte[] body) throws IOException {
        return MessageSerde.get().decode(body);
    }
}

