/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.api;

import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.sdk.api.BusinessServiceCallBack;
import kd.bos.kdtx.sdk.entity.BranchParam;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ECServiceTemplate<T, V> {
    private static Log logger = LogFactory.getLog(ECServiceTemplate.class);
    private V v;
    private String dtxCode;
    private List<BranchParam> parmas;
    private DBRoute dbRoute;

    public ECServiceTemplate(V v, String dtxCode, DBRoute dbRoute, List<BranchParam> parmas) {
        this.v = v;
        this.dtxCode = dtxCode;
        this.parmas = parmas;
        this.dbRoute = dbRoute;
    }

    public T doService(BusinessServiceCallBack callBack, boolean async) throws Exception {
        T o = null;
        ECSession session = null;
        try (TXHandle required = TX.requiresNew();){
            try {
                o = callBack.doBusiness(this.v);
                session = DtxFactory.createEC(this.dtxCode);
                session.setDbRoute(this.dbRoute);
                session.begin();
                for (BranchParam param : this.parmas) {
                    session.register(param.getCloudId(), param.getAppId(), param.getServiceName(), param.getParam(), null, param.getBizId());
                }
            }
            catch (Exception e) {
                required.markRollback();
                if (session != null) {
                    session.rollback(async);
                }
                T t = o;
                if (required != null) {
                    if (var6_6 != null) {
                        try {
                            required.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        required.close();
                    }
                }
                return t;
            }
        }
        session.commit(async);
        return o;
    }
}

