/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.constant.BranchStatus;
import kd.bos.kdtx.common.entity.BranchExecuteInfo;
import kd.bos.kdtx.common.entity.TxLogInfo;
import kd.bos.kdtx.common.param.ListTxLogParam;
import kd.bos.kdtx.common.response.CompensateResponse;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class KdtxBusinessHelper {
    public static List<TxLogInfo> queryTxLogInfo(String sceneCode, String businessId) {
        List<String> xidList = KdtxBusinessHelper.queryXidBySceneCodeAndBusinessId(sceneCode, businessId);
        if (xidList.isEmpty()) {
            return Collections.emptyList();
        }
        DtxTxDispatchService dtxTxDispatchService = KdtxBusinessHelper.serviceLookup(AppInfo.APP_ID.getName());
        ArrayList<TxLogInfo> logInfoList = new ArrayList<TxLogInfo>(8);
        for (String xid : xidList) {
            ListTxLogParam listTxLogParam = new ListTxLogParam();
            listTxLogParam.setXid(xid);
            List logInfos = dtxTxDispatchService.listTxLog(listTxLogParam);
            logInfoList.addAll(logInfos);
        }
        return logInfoList;
    }

    public static Map<String, List<TxLogInfo>> queryTxLogInfo(String businessId) {
        HashMap<String, List<TxLogInfo>> xidLogs = new HashMap<String, List<TxLogInfo>>(8);
        List<String> xidList = KdtxBusinessHelper.queryXidByBusinessId(businessId);
        DtxTxDispatchService dtxTxDispatchService = KdtxBusinessHelper.serviceLookup(AppInfo.APP_ID.getName());
        for (String xid : xidList) {
            ListTxLogParam listTxLogParam = new ListTxLogParam();
            listTxLogParam.setXid(xid);
            List logInfos = dtxTxDispatchService.listTxLog(listTxLogParam);
            xidLogs.put(xid, logInfos);
        }
        return xidLogs;
    }

    public static CompensateResponse manuallyRetry(String sceneCode, String businessId) {
        return KdtxBusinessHelper.manuallyRetry(sceneCode, businessId, true);
    }

    public static CompensateResponse manuallyRetry(String sceneCode, String businessId, boolean sync) {
        List<String> xidlist = KdtxBusinessHelper.queryXidBySceneCodeAndBusinessId(sceneCode, businessId);
        if (xidlist.isEmpty()) {
            return null;
        }
        DtxTxDispatchService dtxTxDispatchService = KdtxBusinessHelper.serviceLookup(AppInfo.APP_ID.getName());
        ArrayList infos = new ArrayList(xidlist.size());
        for (String xid : xidlist) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("xid", xid);
            data.put("seq", "-1");
            data.put("sync", String.valueOf(sync));
            infos.add(data);
        }
        return dtxTxDispatchService.manuallyRetry(infos);
    }

    public static Map<String, List<BranchExecuteInfo>> queryRelativeTxBranchExecuteInfos(String businessId) {
        DtxTxDispatchService dtxTxDispatchService = KdtxBusinessHelper.serviceLookup(AppInfo.APP_ID.getName());
        return dtxTxDispatchService.queryRelativeTxBranchExecuteInfos(businessId);
    }

    public static Map<String, List<BranchExecuteInfo>> queryUncompletedRelativeTxBranchExecuteInfos(String businessId) {
        HashMap<String, List<BranchExecuteInfo>> uncompletedRelativeTxBranchExecuteIfs = new HashMap<String, List<BranchExecuteInfo>>(8);
        Map<String, List<BranchExecuteInfo>> relativeTxBranchExecuteInfos = KdtxBusinessHelper.queryRelativeTxBranchExecuteInfos(businessId);
        relativeTxBranchExecuteInfos.forEach((xid, branchExecuteIfs) -> {
            List uncompletedBranchExecuteIfs = branchExecuteIfs.stream().filter(branchExecuteInfo -> branchExecuteInfo.getBranchStatus() != BranchStatus.COMMITTED.getCode() && branchExecuteInfo.getBranchStatus() != BranchStatus.ROLLBACKED.getCode() && branchExecuteInfo.getBranchStatus() != BranchStatus.DISCARD.getCode()).collect(Collectors.toList());
            if (uncompletedBranchExecuteIfs.size() > 0) {
                uncompletedRelativeTxBranchExecuteIfs.put((String)xid, uncompletedBranchExecuteIfs);
            }
        });
        return uncompletedRelativeTxBranchExecuteIfs;
    }

    private static List<String> queryXidBySceneCodeAndBusinessId(String sceneCode, String businessId) {
        if (StringUtils.isEmpty((String)businessId) || StringUtils.isEmpty((String)sceneCode)) {
            throw new IllegalArgumentException("Scene code or business id is empty");
        }
        String sql = "select fxid as xid from t_cbs_dtx_transaction tcdt join t_cbs_dtx_tx_scenes tcdts on tcdt.fscenes_tx_id = tcdts.fid where fcode = ? and fxid in (select fxid from t_cbs_dtx_business where fbusiness_type = 'kdtx-branch-bizId' and fbusiness_id = ?)";
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{sceneCode, businessId}, rs -> {
            ArrayList<String> xidList = new ArrayList<String>(10);
            while (rs.next()) {
                xidList.add(rs.getString("xid"));
            }
            return xidList;
        });
    }

    private static List<String> queryXidByBusinessId(String businessId) {
        if (StringUtils.isEmpty((String)businessId)) {
            throw new IllegalArgumentException("Scene code or business id is empty");
        }
        String sql = "select fxid from t_cbs_dtx_business where fbusiness_id = ?";
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{businessId}, rs -> {
            ArrayList<String> xidList = new ArrayList<String>(10);
            while (rs.next()) {
                xidList.add(rs.getString("fxid"));
            }
            return xidList;
        });
    }

    private static DtxTxDispatchService serviceLookup(String appId) {
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        DtxTxDispatchService service = (DtxTxDispatchService)ServiceLookup.lookup(DtxTxDispatchService.class, (String)serviceAppId);
        return service;
    }
}

