/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCService;
import kd.bos.kdtx.sdk.entity.DtxTCCLog;
import kd.bos.kdtx.sdk.exception.tcc.TCCLoadDataException;
import kd.bos.kdtx.sdk.exception.tcc.TCCLogInsertException;
import kd.bos.kdtx.sdk.exception.tcc.TCCLogUpdateException;
import kd.bos.kdtx.sdk.exception.tcc.TCCSaveDataException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class TCCAdapterService
implements TCCService {
    private static Log logger = LogFactory.getLog(TCCAdapterService.class);

    public abstract void Try(Object var1) throws Exception;

    public abstract DtxResponse confirm(Object var1, Object var2) throws Exception;

    public abstract void cancel(Object var1) throws Exception;

    @Override
    @SdkInternal
    public final void doTry(Object param) throws Exception {
        if (!this.isPreparing()) {
            String message = "branch status is not PREPARING, can not try!";
            logger.error(message);
            throw new TCCTryException(message);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.Try(param);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Override
    @SdkInternal
    public final DtxResponse doConfirm(Object param, Object lastReturn) throws Exception {
        DtxResponse dtxResponse;
        try (TXHandle tx = TX.requiresNew();){
            try {
                dtxResponse = this.confirm(param, lastReturn);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        this.deleteData();
        return dtxResponse;
    }

    @Override
    @SdkInternal
    public final void doCancel(Object param) throws Exception {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.cancel(param);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        this.deleteData();
    }

    protected void saveData(Set<String> appendDataSet) throws TCCSaveDataException {
        int appendDataSize;
        if (appendDataSet == null || appendDataSet.size() == 0) {
            throw new TCCSaveDataException("dataList is empty.");
        }
        int saveDataSize = this.countSaveData();
        if (saveDataSize + (appendDataSize = appendDataSet.size()) > DtxConfig.getTCCSaveDataLimit()) {
            throw new TCCSaveDataException("size of dataList > max limit.");
        }
        for (String appendData : appendDataSet) {
            if (StringUtils.isEmpty((String)appendData) || appendData.length() <= 500) continue;
            String errorMsg = "append data contains string which length over 500";
            throw new TCCSaveDataException(errorMsg);
        }
        this.save(appendDataSet);
    }

    protected void saveData(String data) throws TCCSaveDataException {
        HashSet<String> set = new HashSet<String>(1);
        set.add(data);
        this.saveData(set);
    }

    protected Set<String> loadData() throws TCCLoadDataException {
        String sql = "SELECT fdata FROM t_cbs_dtx_tcc_branchdata WHERE fxid = ? AND fbranch_id = ? AND ftype = '0'";
        Object[] params = new Object[]{KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId()};
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            HashSet<String> set = new HashSet<String>(16);
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            if (set.size() == 0) {
                return null;
            }
            return set;
        });
    }

    private void insertLog(Section section) {
        try {
            String sql = "INSERT INTO t_cbs_dtx_tcc_section(fid,fxid,fbranch_id,fsection,fcreate_time) VALUES (?,?,?,?,now())";
            Object[] params = new Object[]{ID.genLongId(), KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId(), section.getCode()};
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
        catch (Exception e) {
            String msg = "tcc log insert error.";
            throw new TCCLogInsertException(msg, e);
        }
    }

    private DtxTCCLog query() {
        String sql = "SELECT fid,fxid,fbranch_id,fsection,fcreate_time,fupdate_time FROM t_cbs_dtx_tcc_section WHERE fxid = ? AND fbranch_id = ?";
        Object[] params = new Object[]{KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId()};
        return (DtxTCCLog)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            DtxTCCLog dtxTCCLog = new DtxTCCLog();
            while (rs.next()) {
                dtxTCCLog.setFid(rs.getLong(1));
                dtxTCCLog.setXid(rs.getString(2));
                dtxTCCLog.setBranchId(rs.getString(3));
                dtxTCCLog.setSection(rs.getString(4));
                dtxTCCLog.setCreateTime(rs.getTimestamp(5));
                dtxTCCLog.setUpdateTime(rs.getTimestamp(6));
            }
            return dtxTCCLog;
        });
    }

    private boolean isExistBranch() {
        String sql = "SELECT COUNT(fid) FROM t_cbs_dtx_branch WHERE fxid = ? AND fbranch_id = ?";
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])this.getQueryParams(), rs -> {
            int count;
            if (rs.next() && (count = rs.getInt(1)) == 1) {
                return true;
            }
            return false;
        });
    }

    private int updateLog(Section section) {
        int updateRows;
        try {
            String sql = "UPDATE t_cbs_dtx_tcc_section SET fsection = ?, fupdate_time = NOW()  WHERE fxid = ? AND fbranch_id = ? AND fsection = ?";
            Object[] params = new Object[]{section.getCode(), KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId(), Section.TRY.getCode()};
            updateRows = DB.update((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
        catch (Exception e) {
            String msg = "tcc log update error.";
            throw new TCCLogUpdateException(msg, e);
        }
        return updateRows;
    }

    private Object[] getQueryParams() {
        Object[] params = new Object[]{KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId()};
        return params;
    }

    private int countSaveData() {
        String sql = "SELECT count(fid) FROM t_cbs_dtx_tcc_branchdata WHERE fxid = ? AND fbranch_id = ?";
        KdtxRequestContext context = KdtxRequestContext.get();
        Object[] params = new Object[]{context.getXid(), context.getBranchId()};
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        });
    }

    private void save(Set<String> dataSet) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String sql = "INSERT INTO t_cbs_dtx_tcc_branchdata(fid, fxid, fbranch_id, fdata, ftype, fcreate_time) VALUES(?, ?, ?, ?, '0', now())";
                ArrayList<Object[]> params = new ArrayList<Object[]>(dataSet.size());
                for (String data : dataSet) {
                    Object[] param = new Object[]{ID.genLongId(), KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId(), data};
                    params.add(param);
                }
                DB.executeBatch((DBRoute)DBRoute.base, (String)sql, params);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void deleteData() {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String sql = "DELETE FROM t_cbs_dtx_tcc_branchdata WHERE fxid = ? AND fbranch_id = ?";
                Object[] param = new Object[]{KdtxRequestContext.get().getXid(), KdtxRequestContext.get().getBranchId()};
                DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])param);
            }
            catch (Exception e) {
                logger.error("TCC delete data Exception.", (Throwable)e);
                tx.markRollback();
            }
        }
    }

    private boolean isPreparing() {
        String sql = "SELECT fstatus FROM t_cbs_dtx_branch WHERE fxid = ? AND fbranch_id = ?";
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])this.getQueryParams(), rs -> {
            int status;
            if (rs.next() && (status = Integer.parseInt(rs.getString(1))) == GlobalTxStatus.PREPARING.getCode()) {
                return true;
            }
            return false;
        });
    }

    public static enum Section {
        TRY("0"),
        CONFIRM("1"),
        CANCEL("2");

        private String code;

        private Section(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

