/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.entity.TxBusinessInfo;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TxCheckUtil {
    public static List<String> loadUnfinishedTx(String businessType, List<String> businessIds) {
        if (businessIds == null || businessIds.isEmpty()) {
            throw new RuntimeException("param businessIds can not be null or empty");
        }
        if (StringUtils.isEmpty((String)businessType)) {
            throw new RuntimeException("param businessType can not be null or empty");
        }
        DtxTxDispatchService dtxTxDispatchService = TxCheckUtil.serviceLookup(AppInfo.APP_ID.getName());
        List businessInfos = dtxTxDispatchService.queryTxBusinessInfo(businessType, businessIds);
        HashSet bizS = new HashSet();
        if (businessInfos != null && businessInfos.size() > 0) {
            for (TxBusinessInfo businessInfo : businessInfos) {
                List tempBiz = businessInfo.getBusinessIds();
                if (tempBiz == null) continue;
                bizS.addAll(tempBiz);
            }
        }
        return new ArrayList<String>(bizS);
    }

    public static List<String> loadUnfinishedTx(List<String> businessIds) {
        if (businessIds == null || businessIds.isEmpty()) {
            throw new RuntimeException("param businessIds can not be null or empty");
        }
        DtxTxDispatchService dtxTxDispatchService = TxCheckUtil.serviceLookup(AppInfo.APP_ID.getName());
        List txBusinessInfoS = dtxTxDispatchService.queryTxBusinessInfo("", businessIds);
        HashSet bizS = new HashSet();
        if (txBusinessInfoS != null && txBusinessInfoS.size() > 0) {
            for (TxBusinessInfo businessInfo : txBusinessInfoS) {
                List tempBiz = businessInfo.getBusinessIds();
                if (tempBiz == null) continue;
                bizS.addAll(tempBiz);
            }
        }
        return new ArrayList<String>(bizS);
    }

    public static Map<String, List<String>> loadUnfinishedTxBusinessInfo(List<String> businessIds) {
        if (businessIds == null || businessIds.isEmpty()) {
            throw new RuntimeException("param businessIds can not be null or empty");
        }
        DtxTxDispatchService dtxTxDispatchService = TxCheckUtil.serviceLookup(AppInfo.APP_ID.getName());
        List txBusinessInfoS = dtxTxDispatchService.queryTxBusinessInfo("", businessIds);
        HashMap<String, List<String>> typeBusinessIds = new HashMap<String, List<String>>();
        if (txBusinessInfoS != null && txBusinessInfoS.size() > 0) {
            for (TxBusinessInfo businessInfo : txBusinessInfoS) {
                List tempBiz = businessInfo.getBusinessIds();
                String type = businessInfo.getFbusinessType();
                List tempIds = typeBusinessIds.computeIfAbsent(type, k -> new ArrayList());
                tempIds.addAll(tempBiz);
            }
        }
        return typeBusinessIds;
    }

    public static List<String> getLocked(String businessType, List<String> businessIds) {
        return TxCheckUtil.loadUnfinishedTx(businessType, businessIds);
    }

    public static List<String> getLocked(List<String> businessIds) {
        return TxCheckUtil.loadUnfinishedTx(businessIds);
    }

    public static Map<String, List<String>> getLockedMap(List<String> businessIds) {
        return TxCheckUtil.loadUnfinishedTxBusinessInfo(businessIds);
    }

    private static DtxTxDispatchService serviceLookup(String appId) {
        DtxTxDispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DtxTxDispatchService)ServiceLookup.lookup(DtxTxDispatchService.class, (String)serviceAppId);
        return service;
    }
}

