/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.service;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.DtxModel;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.mq.ReliableCommonService;
import kd.bos.kdtx.common.service.SimpleAction;
import kd.bos.util.StringUtils;

public class SimpleBeginAction
implements SimpleAction {
    public Object handle(Map<String, Object> params, List<DtxParas> dtxParas) throws Exception {
        String xid = Long.toString(ID.genLongId());
        if (StringUtils.isNotEmpty((String)xid)) {
            this.saveTx(xid, (String)params.get("sceneCode"), (String)params.get("serializer"));
            return xid;
        }
        throw new KdtxException(DtxErrorCodeConstants.XID_EMPTY);
    }

    private void saveTx(String xid, String sceneCode, String serializer) {
        TxSceneInfo txSceneInfo = ReliableCommonService.createMqSceneIfNeed((String)sceneCode);
        String sql = "INSERT INTO t_cbs_dtx_transaction(fid, fxid, ftx_type, fscenes_tx_id, fstatus, ftenant_id, faccount_id, frollback_reason, fmodel, fparent_xid, fsource_branch_id, fserializer, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,now(),now())";
        Object[] params = new Object[]{ID.genLongId(), xid, DtxType.SIMPLEEC.getCode(), Long.parseLong(txSceneInfo.getId()), GlobalTxStatus.PREPARING.getCode(), RequestContext.get().getTenantId(), Long.parseLong(RequestContext.get().getAccountId()), "", DtxModel.RPC.getCode(), Character.valueOf(' '), Character.valueOf(' '), serializer};
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }
}

