/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.common.dto.BranchInvokerParam;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.invoke.Attachment;
import kd.bos.kdtx.common.invoke.BranchInvoker;
import kd.bos.kdtx.common.localtx.LocalTxDbHelper;
import kd.bos.kdtx.common.localtx.LocalTxLog;
import kd.bos.kdtx.common.log.DBLogger;
import kd.bos.kdtx.common.service.SimpleAction;
import kd.bos.kdtx.sdk.service.impl.KdtxBranchDispatchServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class SimpleCommitAction
implements SimpleAction {
    private static final Log log = LogFactory.getLog(SimpleCommitAction.class);
    private KdtxBranchDispatchServiceImpl branchService = new KdtxBranchDispatchServiceImpl();
    private static final String BIZTYPE = "kdtx-branch-bizId";

    public Object handle(Map<String, Object> params, List<DtxParas> dtxParas) throws Exception {
        String onlyInvoke = (String)params.get("onlyInvoke");
        String xid = (String)params.get("xid");
        DBRoute dbRoute = (DBRoute)params.get("routeKey");
        Attachment attachment = new Attachment();
        attachment.setSerializer((String)params.get("serializer"));
        if (dtxParas != null && dtxParas.size() > 0) {
            boolean success = true;
            Iterator<DtxParas> it = dtxParas.iterator();
            while (it.hasNext()) {
                DtxParas dtx = it.next();
                try {
                    dtx.setAttachment(attachment);
                    this.limitCacheRecover(dtx, dbRoute, xid);
                    String factory = String.format("kd.%s.%s.servicehelper.ServiceFactory", dtx.getCloudId(), dtx.getAppId());
                    this.saveBranchBizId(xid, dtx.getBizId());
                    BranchInvokerParam branchInvokerParam = BranchInvoker.assembleBranchTransferParam((DtxParas)dtx);
                    this.branchService.commit(factory, dtx.getResource(), branchInvokerParam);
                    if (StringUtils.isEmpty((String)onlyInvoke)) {
                        LocalTxDbHelper.updateLocalBranchStatus((DBRoute)dbRoute, (String)xid, (long)dtx.getSeq(), (LocalTxLogStatus)LocalTxLogStatus.PUBLISHED, (LocalTxLogStatus)LocalTxLogStatus.UNPUBLISHED);
                    }
                }
                catch (Exception e) {
                    success = false;
                    DBLogger.insertActionLog((String)xid, (long)dtx.getSeq(), (ActionType)ActionType.TX_EXECUTE_DIRECT, (int)-1, (String)ExceptionUtils.getExceptionStackTraceMessage((Exception)e), (int)TriggerType.NORMAL.getCode());
                }
                it.remove();
            }
            if (success && StringUtils.isEmpty((String)onlyInvoke)) {
                this.updateTxStatus(xid, GlobalTxStatus.COMMITTED);
            }
        }
        return null;
    }

    private void updateTxStatus(String xid, GlobalTxStatus txStatus) {
        try (TXHandle tx = TX.requiresNew();){
            String sql = "UPDATE t_cbs_dtx_transaction SET fstatus = ?, fsecondstatus = ?, fupdate_time = NOW() WHERE fxid = ? AND fstatus = ?";
            Object[] params = new Object[]{txStatus.getCode(), LocalTxLogStatus.PUBLISHED.getCode(), xid, GlobalTxStatus.PREPARING.getCode()};
            DB.update((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
    }

    private void saveBranchBizId(String xid, String bizId) {
        if (StringUtils.isEmpty((String)bizId)) {
            return;
        }
        String busSql = "INSERT INTO t_cbs_dtx_business(fid,fxid,fbranch_id,fbusiness_id,fbusiness_type,fcreate_time) VALUES(?,?,?,?,?,now())";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1000);
        List<String> contextBusinessIds = this.convert2List(bizId);
        List distinctList = contextBusinessIds.stream().distinct().collect(Collectors.toList());
        List partition = Lists.partition(distinctList, (int)1000);
        try (TXHandle txHandle = TX.requiresNew();){
            for (List list : partition) {
                block17: {
                    for (String businessId : list) {
                        Object[] busParams = new Object[]{ID.genLongId(), xid, "", businessId, BIZTYPE};
                        paramList.add(busParams);
                    }
                    try {
                        DB.executeBatch((DBRoute)DBRoute.base, (String)busSql, paramList);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block17;
                        log.debug("xid={},BranchBizId={},saveBranchBizId fail:", new Object[]{xid, bizId, e});
                    }
                }
                paramList.clear();
            }
        }
    }

    private List<String> convert2List(String bizIds) {
        if (StringUtils.isNotEmpty((String)bizIds)) {
            HashSet<String> set = new HashSet<String>(16);
            String[] ids = bizIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                set.add(ids[i]);
            }
            return new ArrayList<String>(set);
        }
        return Collections.EMPTY_LIST;
    }

    private void limitCacheRecover(DtxParas dtxParas, DBRoute dbRoute, String xid) {
        if (dtxParas.isCacheCleared()) {
            TreeSet localTxLogs = LocalTxDbHelper.getLocalTxLogList((DBRoute)dbRoute, (String)xid, (Long)dtxParas.getSeq());
            if (localTxLogs.size() == 1) {
                dtxParas.setXid(((LocalTxLog)localTxLogs.first()).getXid());
                dtxParas.setCloudId(((LocalTxLog)localTxLogs.first()).getCloudId());
                dtxParas.setAppId(((LocalTxLog)localTxLogs.first()).getAppId());
                dtxParas.setResource(((LocalTxLog)localTxLogs.first()).getResource());
                dtxParas.setParamType(((LocalTxLog)localTxLogs.first()).getParaType());
                dtxParas.setParam(((LocalTxLog)localTxLogs.first()).getParas());
                dtxParas.setBizId(((LocalTxLog)localTxLogs.first()).getBizId());
                dtxParas.setParasBytes(((LocalTxLog)localTxLogs.first()).getParaBytes());
            } else {
                throw new KdtxException("limitCacheRecover get localTxLog size!=1 by xid=" + xid + " and seq=" + dtxParas.getSeq());
            }
        }
    }
}

