/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session;

import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.annotation.SdkInternal;

public class DTXHandle
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(DTXHandle.class);
    private TXHandle txHandle;
    private ECSession session;

    DTXHandle(TXHandle txHandle, String scenesCode, boolean isAsync, boolean runMqModel, DBRoute dbRoute) {
        this.txHandle = txHandle;
        this.session = DtxFactory.createEC(scenesCode);
        this.session.setAsyncCommit(isAsync);
        this.session.setAsyncRollback(isAsync);
        this.session.setRunMqModel(runMqModel);
        if (dbRoute != null) {
            this.session.setDbRoute(dbRoute);
        }
        try {
            this.session.begin();
        }
        catch (Exception e) {
            ExceptionLogger.error(DTXHandle.class, (String)"KdtxMonitorLog Kdtx begin error", (Throwable)e);
            if (e instanceof BeginDtxException) {
                throw (BeginDtxException)e;
            }
            throw new BeginDtxException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        this.txHandle.close();
    }

    public void markRollback() {
        this.txHandle.markRollback();
    }

    public TXHandle getTxHandle() {
        return this.txHandle;
    }

    public void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, String bizId) {
        this.session.register(cloudId, appId, serviceName, param, branchScenesCode, bizId);
    }

    public void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, List<String> bizIds) {
        this.session.register(cloudId, appId, serviceName, param, branchScenesCode, bizIds);
    }

    public void register(String cloudId, String appId, String serviceName) {
        this.session.register(cloudId, appId, serviceName, null, null, "");
    }

    public void register(String cloudId, String appId, String serviceName, Param param) {
        this.session.register(cloudId, appId, serviceName, param, null, "");
    }

    public void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode) {
        this.session.register(cloudId, appId, serviceName, param, branchScenesCode, "");
    }

    @SdkDeprecated
    @SdkInternal
    public void setBusinessType(String businessType) throws KdtxException {
        this.session.setBusinessType(businessType);
    }

    public void setBusinessInfo(List<String> businessIds) throws KdtxException {
        this.session.setBusinessInfo(businessIds);
    }

    public void setCallback(String appId, DTXCallback dtxCallback) {
        this.session.setCallback(appId, dtxCallback);
    }
}

