/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.constant.TxActionType;
import kd.bos.kdtx.common.entity.KdtxSuspendInfo;
import kd.bos.kdtx.common.util.KdtxSuspendProxy;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.context.TCCContext;
import kd.bos.kdtx.sdk.session.AbstractSession;
import kd.bos.kdtx.sdk.session.ParentSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ListenSession
extends ParentSession {
    private static final Log logger = LogFactory.getLog(ListenSession.class);
    private static Set<Long> dbTxIds = new HashSet<Long>();
    private static ThreadLocal<ListenSession> curSession = new ThreadLocal();

    protected void addCommitListener() {
        if (curSession.get() != this) {
            curSession.set(this);
        }
        if (TX.inTX()) {
            final long dbTxId = TX.__getTXContext().id();
            KdtxRequestContext.get().bindLocalTx(dbTxId);
            if (dbTxIds.add(dbTxId)) {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onCommitted() {
                        ListenSession.this.onCommitted(dbTxId);
                    }

                    public void onRollbacked() {
                        ListenSession.this.onRollbacked(dbTxId);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCommitted(long dbTxId) {
        try (TXHandle x = TX.requiresNew();){
            try {
                ListenSession session = ListenSession.getCurrentSession();
                if (session != null) {
                    AbstractSession abstractSession = (AbstractSession)session;
                    boolean isAsyncCommit = abstractSession.isAsyncCommit();
                    abstractSession.commit(isAsyncCommit);
                }
                this.resume(dbTxId, TxActionType.COMMIT);
            }
            catch (Exception e) {
                x.markRollback();
                logger.error("KdtxMonitorLog onCommitted error,will retry in background", (Throwable)e);
            }
            finally {
                this.cleanContext(dbTxId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRollbacked(long dbTxId) {
        try (TXHandle x = TX.requiresNew();){
            try {
                ListenSession session = ListenSession.getCurrentSession();
                if (session != null) {
                    AbstractSession abstractSession = (AbstractSession)session;
                    boolean isAsyncRollback = abstractSession.isAsyncRollback();
                    abstractSession.rollback(isAsyncRollback);
                }
                this.resume(dbTxId, TxActionType.ROLLBACK);
            }
            catch (Exception e) {
                x.markRollback();
                logger.error("KdtxMonitorLog onRollbacked error,will retry in background", (Throwable)e);
            }
            finally {
                this.cleanContext(dbTxId);
            }
        }
    }

    public static ListenSession getCurrentSession() {
        return curSession.get();
    }

    private void cleanContext(long dbTxId) {
        KdtxRequestContext.get().setCommitted(true);
        KdtxRequestContext.get().setFirst(true);
        DtxContext.remove();
        TCCContext.remove();
        curSession.remove();
        dbTxIds.remove(dbTxId);
        Stack waitCommitSet = KdtxSuspendProxy.getWaitCommitInfo((Long)dbTxId);
        if (waitCommitSet != null) {
            while (!waitCommitSet.empty()) {
                KdtxSuspendInfo kdtxSuspendInfo = (KdtxSuspendInfo)waitCommitSet.pop();
                KdtxRequestContext.get().decrWaitCommitSize();
                String waitCommitXid = kdtxSuspendInfo.getXid();
                KdtxRequestContext.popDealedTx((String)waitCommitXid);
            }
        }
        KdtxSuspendProxy.cleanWaitCommit((Long)dbTxId);
    }
}

