/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session.ec;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.util.AssertUtils;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.exception.DtxSdkException;
import kd.bos.kdtx.sdk.exception.ExceptionUtil;
import kd.bos.kdtx.sdk.exception.NoLocalTxException;
import kd.bos.kdtx.sdk.exception.RegisterDtxException;
import kd.bos.kdtx.sdk.session.AbstractSession;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ListenSession;
import kd.bos.kdtx.sdk.session.Session;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.kdtx.sdk.tm.TransactionManagerHolder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class ECGlobalSession {
    private static final Log log = LogFactory.getLog(ECGlobalSession.class);

    public static void begin(String scenesCode, DBRoute dbRoute, boolean isReentrant) throws KDException {
        ECSession session = null;
        if (isReentrant) {
            session = (ECSession)kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
        }
        if (session == null) {
            AssertUtils.assertTrueAndLog((boolean)StringUtils.isNotEmpty((String)scenesCode), (String)"KdtxMonitorLog ECGlobalSession begin error, scenesCode is empty", (RuntimeException)new BeginDtxException(DtxErrorCodeConstants.TXCODE_EMPTY));
            session = DtxFactory.createEC(scenesCode);
            session.setDbRoute(dbRoute);
        }
        try {
            session.begin(isReentrant);
        }
        catch (Exception e) {
            String errorMessage = "KdtxMonitorLog ECGlobalSession begin error.";
            ECGlobalSession.error(errorMessage, e);
            throw ExceptionUtil.wrapBeginExcpetion(e);
        }
        kd.bos.kdtx.sdk.context.DtxContext.setDtxSession(session);
    }

    public static void begin(String scenesCode, DBRoute dbRoute) throws KDException {
        ECGlobalSession.begin(scenesCode, dbRoute, false);
    }

    public static void begin(String scenesCode) throws KDException {
        ECGlobalSession.begin(scenesCode, null, false);
    }

    @SdkInternal
    public static void begin(String scenesCode, DBRoute dbRoute, GlobalSessionType globalSessionType) {
        boolean reentrant = false;
        if (globalSessionType == GlobalSessionType.COMBINATION && !KdtxRequestContext.get().isCommitted()) {
            AbstractSession session = (AbstractSession)ListenSession.getCurrentSession();
            if (session != null) {
                session.suspend();
            }
        } else if (globalSessionType == GlobalSessionType.REENTRANT) {
            reentrant = true;
        } else if (globalSessionType == GlobalSessionType.NEW_BUILD) {
            reentrant = false;
        }
        ECGlobalSession.begin(scenesCode, dbRoute, reentrant);
    }

    @SdkInternal
    @Deprecated
    public static void begin(String scenesCode, DBRoute dbRoute, Propagation propagation) {
        ECGlobalSession.begin(scenesCode, dbRoute, GlobalSessionType.COMBINATION);
    }

    public static void txCommit() throws KDException {
        ECGlobalSession.assertExistLocalTx();
        TXHandle.get().commit();
    }

    public static void setAsync(boolean async) throws KDException {
        Session session = kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
        if (session == null) {
            throw new RegisterDtxException(DtxErrorCodeConstants.SESSION_EMPTY);
        }
        ECSession ecSession = (ECSession)session;
        ecSession.setAsyncCommit(async);
        ecSession.setAsyncRollback(async);
    }

    public static void setProcessMode(boolean waitAllDone, boolean oneByOne) throws KDException {
        Session session = kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
        if (session == null) {
            throw new DtxSdkException(DtxErrorCodeConstants.SESSION_EMPTY);
        }
        boolean asyncCommit = false;
        boolean runMqModel = false;
        if (!waitAllDone) {
            asyncCommit = true;
            runMqModel = !oneByOne;
        }
        ECSession ecSession = (ECSession)session;
        ecSession.setAsyncCommit(asyncCommit);
        ecSession.setRunMqModel(runMqModel);
    }

    public static void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, List<String> bizIds) throws KDException {
        Session session = kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
        if (session == null) {
            throw new RegisterDtxException(DtxErrorCodeConstants.SESSION_EMPTY);
        }
        ECSession ecSession = (ECSession)session;
        try {
            ecSession.register(cloudId, appId, serviceName, param, branchScenesCode, bizIds);
        }
        catch (Exception e) {
            String errorMessage = "ECGlobalSession register error.";
            ECGlobalSession.error(errorMessage, e);
            throw ExceptionUtil.wrapRegisterExcpetion(e);
        }
    }

    public static void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, String bizId) throws KDException {
        ArrayList<String> bizIds = null;
        if (StringUtils.isNotEmpty((String)bizId)) {
            bizIds = new ArrayList<String>(1);
            bizIds.add(bizId);
        }
        ECGlobalSession.register(cloudId, appId, serviceName, param, branchScenesCode, bizIds);
    }

    public static void register(String cloudId, String appId, String serviceName) throws KDException {
        ECGlobalSession.register(cloudId, appId, serviceName, null, null, "");
    }

    public static void register(String cloudId, String appId, String serviceName, Param param) throws KDException {
        ECGlobalSession.register(cloudId, appId, serviceName, param, null, "");
    }

    public static void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode) throws KDException {
        ECGlobalSession.register(cloudId, appId, serviceName, param, branchScenesCode, "");
    }

    @Deprecated
    @SdkDeprecated
    @SdkInternal
    public static void end(boolean asyncEnd) {
        try {
            Session session = kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
            ECSession ecSession = (ECSession)session;
            if (kd.bos.kdtx.sdk.context.DtxContext.isError()) {
                ecSession.rollback(asyncEnd);
            } else {
                ecSession.commit(asyncEnd);
            }
        }
        catch (Exception e) {
            log.warn("commit/rollback\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u672c\u5730\u4e8b\u52a1\u76d1\u542c\u5668\u5df2\u5904\u7406\u3002", (Throwable)e);
        }
        finally {
            kd.bos.kdtx.sdk.context.DtxContext.remove();
        }
    }

    @Deprecated
    @SdkDeprecated
    @SdkInternal
    public static void end() {
        ECGlobalSession.end(true);
    }

    @SdkDeprecated
    @SdkInternal
    public static void setGlobalError(String message) {
        ECGlobalSession.error(message, null);
    }

    private static void error(String message, Exception e) {
        if (e != null) {
            ExceptionLogger.error(ECGlobalSession.class, (String)message, (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)message)) {
            kd.bos.kdtx.sdk.context.DtxContext.setErrorMessage(message);
        }
        kd.bos.kdtx.sdk.context.DtxContext.setError(true);
    }

    public static void setBusinessType(String businessType) throws KdtxException {
        if (StringUtils.isEmpty((String)businessType)) {
            throw new KdtxException("ECGlobalSession: param businessType can not be null or empty");
        }
        if ("kdtx-branch-bizId".equals(businessType)) {
            throw new KdtxException("ECGlobalSession: param businessType can not be [kdtx-branch-bizId],this only for inner system");
        }
        DtxContext.setBusinessType((String)businessType);
    }

    public static void setBusinessInfo(List<String> businessIds) throws KdtxException {
        if (CollectionUtils.isEmpty(businessIds)) {
            throw new KdtxException("ECGlobalSession: param businessIds can not be null or empty");
        }
        if (!DtxContext.isSetBusinessType()) {
            throw new KdtxException("businessType should be setted before set businessInfo or setted in sceneInfo list page");
        }
        DtxContext.setBusinessIds(businessIds);
        if (StringUtils.isNotEmpty((String)KdtxRequestContext.get().getXid()) && !KdtxRequestContext.get().isCommitted()) {
            try {
                TransactionManagerHolder.get().setBusinessInfo();
            }
            catch (Exception e) {
                throw new KdtxException("set businessInfo fail", (Throwable)e);
            }
        }
    }

    public static void setCallback(String appId, DTXCallback dtxCallback) {
        Session session = kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
        if (session == null) {
            ExceptionLogger.error(ECGlobalSession.class, (String)"KdtxMonitorLog ECGlobalSession register session is null");
            throw new RegisterDtxException(DtxErrorCodeConstants.SESSION_EMPTY);
        }
        ECSession ecSession = (ECSession)session;
        ecSession.setCallback(appId, dtxCallback);
    }

    public static boolean isExistDtx() {
        boolean exist = true;
        try {
            ECGlobalSession.assertSessionExist();
        }
        catch (RegisterDtxException e) {
            exist = false;
        }
        return exist;
    }

    private static ECSession assertSessionExist() throws KdtxException {
        Session session = kd.bos.kdtx.sdk.context.DtxContext.getDtxSession();
        if (session == null) {
            throw new RegisterDtxException(DtxErrorCodeConstants.SESSION_EMPTY);
        }
        ECSession ecSession = (ECSession)session;
        return ecSession;
    }

    private static void assertExistLocalTx() throws NoLocalTxException {
        if (!TX.inTX()) {
            String message = "no local tx error.";
            log.error(message);
            throw new NoLocalTxException(message);
        }
    }
}

