/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session.ec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.localtx.LocalTxDbHelper;
import kd.bos.kdtx.common.mq.PublishManager;
import kd.bos.kdtx.common.util.AssertUtils;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.sdk.exception.DtxSdkException;
import kd.bos.kdtx.sdk.exception.RegisterDtxException;
import kd.bos.kdtx.sdk.session.AbstractSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ECSession
extends AbstractSession {
    private static final Log log = LogFactory.getLog(ECSession.class);
    private static Map<String, List<DtxParas>> batchMsg = new HashMap<String, List<DtxParas>>();

    public ECSession() {
        this.setDtxType(DtxType.EC);
        this.setRunMqModel(true);
    }

    @Override
    protected void doRollback() throws Exception {
        String curDealXid = KdtxRequestContext.get().getXid();
        if (batchMsg.remove(curDealXid) != null) {
            try {
                this.getTm().txRollback();
            }
            finally {
                KdtxRequestContext.popDealedTx((String)curDealXid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SdkInternal
    protected void doCommit() throws Exception {
        String curDealXid = KdtxRequestContext.get().getXid();
        List<DtxParas> dtxParas = batchMsg.remove(curDealXid);
        if (dtxParas != null) {
            MessagePublisher pub = null;
            String parentBranchId = KdtxRequestContext.get().getBranchId();
            try {
                if (DtxConfig.canRunMqMode((boolean)this.isRunMqModel())) {
                    DtxContext.setRunMqModel((boolean)true);
                    pub = PublishManager.getPublisher((String)this.getScenesCode());
                }
                int totalBranches = dtxParas.size();
                Iterator<DtxParas> it = dtxParas.iterator();
                while (it.hasNext()) {
                    DtxParas para = it.next();
                    para.setTotalBranch(totalBranches);
                    para.setXid(curDealXid);
                    if (!DtxConfig.canRunMqMode((boolean)this.isRunMqModel())) {
                        this.getTm().branchRegister(para);
                    } else {
                        String branchId = Long.toString(ID.genLongId());
                        para.setBranchId(branchId);
                        if (pub != null) {
                            pub.publish((Object)para, para.getAppId());
                        }
                    }
                    it.remove();
                }
                if (!DtxConfig.canRunMqMode((boolean)this.isRunMqModel())) {
                    this.getTm().txCommit();
                }
            }
            finally {
                KdtxRequestContext.get().setBranchId(parentBranchId);
                KdtxRequestContext.popDealedTx((String)curDealXid);
                if (pub != null) {
                    pub.close();
                }
            }
        }
    }

    @Deprecated
    @SdkDeprecated
    @SdkInternal
    public void setBusinessType(String businessType) throws KdtxException {
        if (StringUtils.isEmpty((String)businessType)) {
            throw new KdtxException("param businessType can not be null or empty");
        }
        DtxContext.setBusinessType((String)businessType);
    }

    public void setBusinessInfo(List<String> businessIds) throws KdtxException {
        if (CollectionUtils.isEmpty(businessIds)) {
            throw new KdtxException("param businessIds can not be null or empty");
        }
        if (!DtxContext.isSetBusinessType()) {
            throw new KdtxException("businessType should be setted before set businessInfo or setted in sceneInfo list page");
        }
        DtxContext.setBusinessIds(businessIds);
        if (StringUtils.isNotEmpty((String)KdtxRequestContext.get().getXid()) && !KdtxRequestContext.get().isCommitted()) {
            try {
                this.getTm().setBusinessInfo();
            }
            catch (Exception e) {
                throw new KdtxException("setBusinessInfo error:", (Throwable)e);
            }
        }
    }

    public void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, List<String> bizIds) throws DtxSdkException {
        KdtxRequestContext.get().setCommitted(false);
        try {
            AssertUtils.assertTrueAndLog((boolean)TX.inTX(), (String)"KdtxMonitorLog local tx has not begin.", (RuntimeException)new RegisterDtxException(DtxErrorCodeConstants.LOCAL_TX_EMPTY));
            AssertUtils.assertTrue((this.getDtxType() != null ? 1 : 0) != 0, (RuntimeException)new RegisterDtxException(DtxErrorCodeConstants.DTX_NOT_BEGIN));
            String writtenRouteKey = TX.getWrittenRouteKey() != null ? TX.getWrittenRouteKey() : (this.dbRoute == null ? "" : this.dbRoute.getRouteKey());
            AssertUtils.assertTrueAndLog((boolean)StringUtils.isNotEmpty((String)writtenRouteKey), (String)"KdtxMonitorLog dbRoute is empty, pls write the business DB first.", (RuntimeException)new RegisterDtxException(DtxErrorCodeConstants.DB_ROUTE_EMPTY));
            this.dbRoute = DBRoute.of((String)writtenRouteKey);
            AssertUtils.assertTrueAndLog((StringUtils.isNotEmpty((String)cloudId) && StringUtils.isNotEmpty((String)appId) && StringUtils.isNotEmpty((String)serviceName) ? 1 : 0) != 0, (String)"KdtxMonitorLog some param is empty, pls confirm.", (RuntimeException)new RegisterDtxException(DtxErrorCodeConstants.CLOUDID_OR_APPID_EMPTY));
            this.doBegin();
            String xid = KdtxRequestContext.get().getXid();
            AssertUtils.assertTrueAndLog((boolean)StringUtils.isNotEmpty((String)xid), (String)"KdtxMonitorLog xid is empty, pls confirm the tcc is begin.", (RuntimeException)new RegisterDtxException(DtxErrorCodeConstants.XID_EMPTY));
            this.addCommitListener();
            String bizId = ECSession.covert2Str(bizIds);
            DtxParas dtxParas = new DtxParas();
            dtxParas.setCloudId(cloudId);
            dtxParas.setAppId(appId);
            dtxParas.setResource(serviceName);
            dtxParas.setParamType("");
            dtxParas.setParam("");
            dtxParas.setSceneCode(this.getScenesCode());
            dtxParas.setBranchCode(branchScenesCode == null ? "" : branchScenesCode);
            dtxParas.setBizId(bizId);
            dtxParas.setTxType(this.getDtxType().getCode() + "");
            dtxParas.setParasBytes(JsonUtils.serialization((Object)param));
            List msgs = batchMsg.computeIfAbsent(xid, k -> new ArrayList());
            dtxParas.setSeq((long)msgs.size());
            msgs.add(dtxParas);
            LocalTxDbHelper.insert((DBRoute)this.dbRoute, (String)xid, (DtxParas)dtxParas);
        }
        catch (Exception e) {
            KdtxRequestContext.get().setCommitted(true);
            KdtxRequestContext.get().setFirst(true);
            throw e;
        }
    }

    private void checkParamSize(String jsonParam) {
        byte[] bytes = jsonParam.getBytes();
        if ((long)bytes.length > DtxConfig.getMaxParamSize()) {
            throw new RegisterDtxException(DtxErrorCodeConstants.MAX_PARAM_SIZE);
        }
    }

    public void register(String cloudId, String appId, String serviceName) throws KDException {
        this.register(cloudId, appId, serviceName, null, null, "");
    }

    public void register(String cloudId, String appId, String serviceName, Param param) throws KDException {
        this.register(cloudId, appId, serviceName, param, null, "");
    }

    public void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode) throws KDException {
        this.register(cloudId, appId, serviceName, param, branchScenesCode, "");
    }

    public void register(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, String bizId) throws DtxSdkException {
        ArrayList<String> bizIds = null;
        if (StringUtils.isNotEmpty((String)bizId)) {
            bizIds = new ArrayList<String>(1);
            bizIds.add(bizId);
        }
        this.register(cloudId, appId, serviceName, param, branchScenesCode, bizIds);
    }
}

