/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session.simpleec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.localtx.LocalTxDbHelper;
import kd.bos.kdtx.common.service.KdtxSerializer;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.sdk.exception.RegisterDtxException;
import kd.bos.kdtx.sdk.init.TableInitConfig;
import kd.bos.kdtx.sdk.service.SimpleActionFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.util.StringUtils;

public class SimpleECSession {
    private DtxType dtxType = DtxType.SIMPLEEC;
    private String scenesCode;
    private DBRoute dbRoute;
    private String serializer = "";
    private String xid;
    private static AtomicLong totalSize = new AtomicLong(0L);
    private static Map<String, List<DtxParas>> batchMsg = new HashMap<String, List<DtxParas>>();
    public static Map<Long, String> dBTxIdXidCache = new HashMap<Long, String>();

    public SimpleECSession(String scenesCode) {
        this.scenesCode = scenesCode;
    }

    public SimpleECSession(String scenesCode, String serializer) {
        this.scenesCode = scenesCode;
        this.setSerializer(serializer);
    }

    public void register(String cloudId, String appId, String serviceName, Object param, List<String> bizIds) throws RegisterDtxException {
        this.check(cloudId, appId, serviceName);
        final HashMap<String, Object> dto = new HashMap<String, Object>();
        dto.put("sceneCode", this.scenesCode);
        dto.put("serializer", this.serializer);
        dto.put("routeKey", this.dbRoute);
        this.doBegin(dto);
        if (StringUtils.isEmpty((String)this.xid)) {
            throw new RegisterDtxException(DtxErrorCodeConstants.XID_EMPTY);
        }
        dto.put("xid", this.getXid());
        String bizId = ECSession.covert2Str(bizIds);
        DtxParas dtxParas = new DtxParas();
        dtxParas.setXid(this.xid);
        dtxParas.setCloudId(cloudId);
        dtxParas.setAppId(appId);
        dtxParas.setResource(serviceName);
        dtxParas.setParamType("");
        dtxParas.setParam("");
        dtxParas.setBizId(bizId);
        dtxParas.setSceneCode(this.getScenesCode());
        dtxParas.setBranchCode("");
        dtxParas.setTxType(this.getDtxType().getCode() + "");
        List<DtxParas> msgs = batchMsg.get(this.xid);
        if (msgs == null || msgs.size() == 0) {
            ArrayList<DtxParas> list = new ArrayList<DtxParas>();
            dtxParas.setSeq(0L);
            list.add(dtxParas);
            batchMsg.put(this.xid, list);
            final Long dbTxId = TX.__getTXContext().id();
            dBTxIdXidCache.put(dbTxId, this.xid);
            TX.addCommitListener((CommitListener)new CommitListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCommitted() {
                    long txMessageTotalSize = SimpleECSession.this.calculateTxMessageSize((List)batchMsg.get(SimpleECSession.this.xid));
                    try (TXHandle x = TX.requiresNew();){
                        try {
                            SimpleActionFactory.getActionInstance(ActionType.TX_COMMIT).handle(dto, (List)batchMsg.get(SimpleECSession.this.xid));
                        }
                        catch (Exception e) {
                            ExceptionLogger.error(SimpleECSession.class, (String)"kdtx Simple commit error,will retry in background", (Throwable)e);
                        }
                        finally {
                            batchMsg.remove(SimpleECSession.this.xid);
                            dBTxIdXidCache.remove(dbTxId);
                            totalSize.addAndGet(-txMessageTotalSize);
                            SimpleECSession.this.setXid(null);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRollbacked() {
                    long txMessageTotalSize = SimpleECSession.this.calculateTxMessageSize((List)batchMsg.get(SimpleECSession.this.xid));
                    try (TXHandle x = TX.requiresNew();){
                        try {
                            SimpleActionFactory.getActionInstance(ActionType.TX_ROLLBACK).handle(dto, null);
                        }
                        catch (Exception e) {
                            ExceptionLogger.error(SimpleECSession.class, (String)"kdtx rollback error,will retry in background", (Throwable)e);
                        }
                        finally {
                            batchMsg.remove(SimpleECSession.this.xid);
                            dBTxIdXidCache.remove(dbTxId);
                            totalSize.addAndGet(-txMessageTotalSize);
                            SimpleECSession.this.setXid(null);
                        }
                    }
                }
            });
        } else {
            dtxParas.setSeq((long)msgs.size());
            msgs.add(dtxParas);
        }
        dtxParas.setParasBytes(this.serialize(param, dtxParas));
        LocalTxDbHelper.insert((DBRoute)this.dbRoute, (String)this.xid, (DtxParas)dtxParas);
        dtxParas.setPersistence(true);
        this.limitCache(dtxParas.getMessageLength());
    }

    private void limitCache(long paramsLength) {
        long currentSize = totalSize.addAndGet(paramsLength);
        if (currentSize >= Long.getLong("kdtx.message.maxCache.size", 0x3200000L)) {
            for (Map.Entry<String, List<DtxParas>> entry : batchMsg.entrySet()) {
                for (DtxParas dtxParas : entry.getValue()) {
                    if (dtxParas.isCacheCleared() || !dtxParas.isPersistence()) continue;
                    dtxParas.messageCacheLimitClear();
                }
            }
        }
    }

    private long calculateTxMessageSize(List<DtxParas> dtxParas) {
        long total = 0L;
        for (DtxParas temp : dtxParas) {
            total += temp.getMessageLength();
        }
        return total;
    }

    private void doBegin(Map<String, Object> dto) {
        if (StringUtils.isEmpty((String)this.xid)) {
            DBRoute dbRoute = (DBRoute)dto.get("routeKey");
            try {
                TableInitConfig.initLocalTable(this.dtxType.getCode(), dbRoute);
            }
            catch (Exception e) {
                throw new RegisterDtxException("Table Init fail", e);
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    String xid = (String)SimpleActionFactory.getActionInstance(ActionType.TX_BEGIN).handle(dto, null);
                    this.setXid(xid);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw new RegisterDtxException("Simple doBegin fail", e);
                }
            }
        }
    }

    private byte[] serialize(Object param, DtxParas dtxParas) {
        if (StringUtils.isNotEmpty((String)this.serializer)) {
            try {
                KdtxSerializer serializer = (KdtxSerializer)Class.forName(this.serializer).newInstance();
                serializer.preSerialize(param, dtxParas);
                return serializer.serialize(param);
            }
            catch (Exception e) {
                throw new KdtxException("serialization error", (Throwable)e);
            }
        }
        return JsonUtils.serialization((Object)param);
    }

    private void check(String cloudId, String appId, String serviceName) {
        String writtenRouteKey;
        if (!TX.inTX()) {
            ExceptionLogger.error(SimpleECSession.class, (String)"local tx has not begin.");
            throw new RegisterDtxException(DtxErrorCodeConstants.LOCAL_TX_EMPTY);
        }
        String string = TX.getWrittenRouteKey() != null ? TX.getWrittenRouteKey() : (writtenRouteKey = this.dbRoute == null ? "" : this.dbRoute.getRouteKey());
        if (StringUtils.isEmpty((String)writtenRouteKey)) {
            ExceptionLogger.error(SimpleECSession.class, (String)"dbRoute is empty, pls write the business DB first");
            throw new RegisterDtxException(DtxErrorCodeConstants.DB_ROUTE_EMPTY);
        }
        this.dbRoute = DBRoute.of((String)writtenRouteKey);
        if (StringUtils.isEmpty((String)cloudId) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)serviceName)) {
            throw new RegisterDtxException(DtxErrorCodeConstants.CLOUDID_OR_APPID_EMPTY);
        }
    }

    private String getScenesCode() {
        return this.scenesCode;
    }

    public void setScenesCode(String scenesCode) {
        this.scenesCode = scenesCode;
    }

    private DtxType getDtxType() {
        return this.dtxType;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public DBRoute getDbRoute() {
        return this.dbRoute;
    }

    public void setDbRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    private void setSerializer(String serializer) {
        if (StringUtils.isNotEmpty((String)serializer)) {
            try {
                Class<?> c = Class.forName(serializer);
                if (!KdtxSerializer.class.isAssignableFrom(c)) {
                    throw new KdtxException("pls make [" + serializer + "] implements KdtxSerializer");
                }
                this.serializer = serializer;
            }
            catch (ClassNotFoundException e) {
                throw new KdtxException("serializer class not found", (Throwable)e);
            }
        }
    }

    public String getXid() {
        return this.xid;
    }

    private void setXid(String xid) {
        this.xid = xid;
    }
}

