/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.tm.impl;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.KdtxRequestContext;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.InvokeType;
import kd.bos.kdtx.common.invoke.factory.InvokerFactory;
import kd.bos.kdtx.common.log.DBLogger;
import kd.bos.kdtx.sdk.tm.TransactionManager;

public class KdtxTransactionManager
implements TransactionManager {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("kdtx", new DistributeCacheHAPolicy(true, false));

    @Override
    public void begin() throws Exception {
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.TX_BEGIN).doInvoke(null);
    }

    @Override
    public void branchRegister(DtxParas tccParas) throws Exception {
        String branchId = Long.toString(ID.genLongId());
        KdtxRequestContext.get().setBranchId(branchId);
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.BRANCH_REGISTER).doInvoke(tccParas);
    }

    @Override
    public void registerCascadeBranch(DtxParas tccParas) throws Exception {
        String branchId = Long.toString(ID.genLongId());
        KdtxRequestContext.get().setBranchId(branchId);
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.CASCADE_BRANCH_REGISTER).doInvoke(tccParas);
    }

    @Override
    public void branchTry(DtxParas tccParas) throws Exception {
        DBLogger.traceAction(() -> {
            String xid = KdtxRequestContext.get().getXid();
            try {
                cache.put("kdtx_branchLongTry_" + xid, (Object)xid, KdtxTransactionManager.getAllowLongTryTime());
                InvokerFactory.getTCCInvoker((InvokeType)InvokeType.PREPARE).doInvoke(tccParas);
            }
            finally {
                cache.remove("kdtx_branchLongTry_" + xid);
            }
        }, (String)KdtxRequestContext.get().getXid(), (String)KdtxRequestContext.get().getBranchId(), (ActionType)ActionType.BRANCH_TRY);
    }

    @Override
    public void txCommit() throws Exception {
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.TX_COMMIT).doInvoke(null);
    }

    @Override
    public void txRollback() throws Exception {
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.TX_ROLLBACK).doInvoke(null);
    }

    @Override
    public void setBusinessInfo() throws Exception {
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.SET_BUSINESS_INFO).doInvoke(null);
    }

    private static int getAllowLongTryTime() {
        int retries = DtxConfig.getBranchPrepareLocalRetries();
        int tryTimeout = DtxConfig.getBranchPrepareTimeout() / 1000;
        if (retries > 0) {
            return retries * tryTimeout;
        }
        return tryTimeout;
    }
}

