/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.crypto;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import kd.bos.crypto.AlgorithmDesc;
import kd.bos.crypto.Encryptor;
import kd.bos.crypto.EncryptorFactory;
import kd.bos.encrypt.EncryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEncrypters {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final Logger log = LoggerFactory.getLogger(MultiEncrypters.class);

    public static Cipher getCipher(String algorithm) {
        Encryptor encryptor = EncryptorFactory.getEncryptor(algorithm);
        return encryptor.getCipher();
    }

    public static String encrypt(String algorithm, String key, int length, String data) {
        Encryptor encryptor = EncryptorFactory.getEncryptor(algorithm);
        if (!encryptor.checkSupportLength(length)) {
            throw new EncryptException("not support key length\uff1a " + algorithm + " " + length);
        }
        return encryptor.encrypt(data, key, length);
    }

    public static String encrypt(Cipher cipher, String algorithm, String key, int length, String data) {
        Encryptor encryptor = EncryptorFactory.getEncryptor(algorithm);
        if (!encryptor.checkSupportLength(length)) {
            throw new EncryptException("not support key length\uff1a " + algorithm + " " + length);
        }
        return encryptor.encrypt(cipher, data, key, length);
    }

    public static String decrypt(String algorithm, String key, int length, String data) {
        Encryptor encryptor = EncryptorFactory.getEncryptor(algorithm);
        if (!encryptor.checkSupportLength(length)) {
            throw new EncryptException("not support key length\uff1a " + algorithm + " " + length);
        }
        return encryptor.decrypt(data, key, length);
    }

    public static String decrypt(Cipher cipher, String algorithm, String key, int length, String data) {
        Encryptor encryptor = EncryptorFactory.getEncryptor(algorithm);
        if (!encryptor.checkSupportLength(length)) {
            throw new EncryptException("not support key length\uff1a " + algorithm + " " + length);
        }
        return encryptor.decrypt(cipher, data, key, length);
    }

    public static List<AlgorithmDesc> getAllAlgorithm() {
        ArrayList<AlgorithmDesc> list = new ArrayList<AlgorithmDesc>();
        EncryptorFactory.getEncryptorMap().forEach((key, value) -> {
            AlgorithmDesc ea = new AlgorithmDesc();
            ea.setTransformation((String)key);
            ea.setSupport(value.supportLength());
            list.add(ea);
        });
        return list;
    }
}

