/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.crypto.impl;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import kd.bos.crypto.Encryptor;
import kd.bos.encrypt.EncryptException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEncryptor
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractEncryptor.class);
    protected SecureRandom random = new SecureRandom();
    protected static final String SUFFIX_IV16 = "#h*16";
    private static final int IV_LENGTH = 16;

    protected abstract String result(byte[] var1, byte[] var2);

    @Override
    public String encrypt(String originalStr, String keyStr, int length) throws EncryptException {
        if (originalStr == null) {
            return null;
        }
        try {
            byte[] key = this.getKeyFromString(keyStr, length);
            byte[] iv = this.getRandomIv();
            byte[] data = this.encrypt0(originalStr, key, iv);
            return this.result(iv, data);
        }
        catch (Exception e) {
            log.error("encrypt error", (Throwable)e);
            throw new EncryptException("encrypt error " + e.getMessage());
        }
    }

    protected abstract byte[] encrypt0(String var1, byte[] var2, byte[] var3) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException;

    @Override
    public String encrypt(Cipher cipher, String originalStr, String keyStr, int length) throws EncryptException {
        if (originalStr == null) {
            return null;
        }
        try {
            byte[] key = this.getKeyFromString(keyStr, length);
            byte[] iv = this.getRandomIv();
            byte[] data = this.encrypt0(cipher, originalStr, key, iv);
            return this.result(iv, data);
        }
        catch (Exception e) {
            log.error("encrypt error", (Throwable)e);
            throw new EncryptException("encrypt error " + e.getMessage());
        }
    }

    protected abstract byte[] encrypt0(Cipher var1, String var2, byte[] var3, byte[] var4) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException;

    @Override
    public String decrypt(String encryptStr, String keyStr, int length) throws EncryptException {
        if (encryptStr == null) {
            return null;
        }
        try {
            byte[] data;
            byte[] iv;
            byte[] key = this.getKeyFromString(keyStr, length);
            if (this.isIv16ModeRandomData(encryptStr)) {
                encryptStr = encryptStr.substring(0, encryptStr.lastIndexOf(SUFFIX_IV16));
                byte[] ivAndData = Base64.decodeBase64((String)encryptStr);
                iv = new byte[16];
                data = new byte[ivAndData.length - 16];
                System.arraycopy(ivAndData, 0, iv, 0, 16);
                System.arraycopy(ivAndData, 16, data, 0, data.length);
            } else {
                iv = this.getIvFromString(keyStr, length);
                data = Base64.decodeBase64((String)encryptStr);
            }
            return this.decrypt0(data, key, iv);
        }
        catch (Exception e) {
            log.error("decrypt error", (Throwable)e);
            throw new EncryptException("decrypt error " + e.getMessage());
        }
    }

    protected abstract String decrypt0(byte[] var1, byte[] var2, byte[] var3) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException;

    @Override
    public String decrypt(Cipher cipher, String encryptStr, String keyStr, int length) throws EncryptException {
        if (encryptStr == null) {
            return null;
        }
        try {
            byte[] data;
            byte[] iv;
            byte[] key = this.getKeyFromString(keyStr, length);
            if (this.isIv16ModeRandomData(encryptStr)) {
                encryptStr = encryptStr.substring(0, encryptStr.lastIndexOf(SUFFIX_IV16));
                byte[] ivAndData = Base64.decodeBase64((String)encryptStr);
                iv = new byte[16];
                data = new byte[ivAndData.length - 16];
                System.arraycopy(ivAndData, 0, iv, 0, 16);
                System.arraycopy(ivAndData, 16, data, 0, data.length);
            } else {
                iv = this.getIvFromString(keyStr, length);
                data = Base64.decodeBase64((String)encryptStr);
            }
            return this.decrypt0(cipher, data, key, iv);
        }
        catch (Exception e) {
            log.error("decrypt error", (Throwable)e);
            throw new EncryptException("decrypt error " + e.getMessage());
        }
    }

    protected abstract String decrypt0(Cipher var1, byte[] var2, byte[] var3, byte[] var4) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException;

    protected abstract byte[] getKeyFromString(String var1, int var2) throws EncryptException;

    protected abstract byte[] getIvFromString(String var1, int var2) throws EncryptException;

    protected abstract byte[] getRandomIv() throws EncryptException;

    private boolean isIv16ModeRandomData(String encryptStr) {
        return encryptStr.endsWith(SUFFIX_IV16);
    }

    protected static byte[] joinIVAndData(byte[] ivByte, byte[] data) {
        byte[] r = new byte[ivByte.length + data.length];
        System.arraycopy(ivByte, 0, r, 0, ivByte.length);
        System.arraycopy(data, 0, r, ivByte.length, data.length);
        return r;
    }
}

