/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.impl;

import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.core.PrefixMatchableEncrypter;
import kd.bos.util.StringUtils;

public class KmsEncrypterSample
extends PrefixMatchableEncrypter {
    private static final String IS_ENABLE_CUST_ENCRYPT = "kd.bos.encrypt.IsEnableCustEncrypt";
    private static final String CUST_ENCRYPT_CONFIG = "kd.bos.encrypt.CustEncryptConfig";
    private static boolean isEnableCustEncrypt = false;
    private static final Object LOCKER = new Object();
    private static KmsSdkClient kmsSdkClient;

    public KmsEncrypterSample() {
        super("custEn:");
    }

    @Override
    protected String decode0(String str) {
        return this.getInstance().dataDecrypt(str);
    }

    @Override
    protected String encode0(String str) {
        return this.getInstance().dataEncrypt(str);
    }

    @Override
    protected boolean checkEncrypt(String str) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KmsSdkClient getInstance() {
        if (kmsSdkClient == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (kmsSdkClient == null) {
                    this.initKmsSdkClient();
                }
            }
        }
        return kmsSdkClient;
    }

    private boolean getCustEncryptEnable() {
        if (isEnableCustEncrypt) {
            return true;
        }
        isEnableCustEncrypt = Boolean.getBoolean(IS_ENABLE_CUST_ENCRYPT);
        return isEnableCustEncrypt;
    }

    private void initKmsSdkClient() {
        String custEncryptConfig = System.getProperty(CUST_ENCRYPT_CONFIG);
        if (StringUtils.isNotEmpty((String)custEncryptConfig)) {
            try {
                kmsSdkClient = new KmsSdkClient();
                kmsSdkClient.init(custEncryptConfig);
            }
            catch (Exception ex) {
                kmsSdkClient = null;
                throw new EncryptException("init KmsSdkClient encrypt Error:" + ex.getMessage(), ex);
            }
        } else {
            throw new EncryptException("cannot init KMS encrypter, because the CUST_ENCRYPT_CONFIG is still null.");
        }
    }

    static class KmsSdkClient {
        KmsSdkClient() {
        }

        public void init(String configKey) {
        }

        public String dataEncrypt(String str) {
            return str;
        }

        public String dataDecrypt(String str) {
            return str;
        }
    }
}

