/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.key;

import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.key.EncryptKeyManager;
import kd.bos.encrypt.util.EncryptProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptKeyFactory {
    private static final String KEY_MANAGER_CLASSNAME = "kd.bos.encrypt.keyManager";
    private static final String DEFAULT_KEY_MANAGER = "kd.bos.encrypt.key.MCEncryptKeyManagerImpl";
    private static final Logger log = LoggerFactory.getLogger(EncryptKeyFactory.class);
    private static final String ENCRYPT_IV_MODE = "kd.bos.encrypt.iv.mode";
    private static final String ENCRYPT_IV_LENGTH = "kd.bos.encrypt.iv.length";
    private static final String ENCRYPT_IV_MODE_RANDOM = "random";
    private static boolean IV_MODE_RANDOM_FLAG;
    private static int ivLength;
    private static EncryptKeyManager instance;

    public static EncryptKeyManager getEncrypterKeyManager() {
        return instance;
    }

    static boolean isRandomIV() {
        return IV_MODE_RANDOM_FLAG;
    }

    static int getIvLength() {
        return ivLength;
    }

    static {
        instance = null;
        IV_MODE_RANDOM_FLAG = ENCRYPT_IV_MODE_RANDOM.equals(EncryptProperties.getWithEnv(ENCRYPT_IV_MODE));
        ivLength = EncryptProperties.getInteger(ENCRYPT_IV_LENGTH, 16);
        String className = EncryptProperties.getWithEnv(KEY_MANAGER_CLASSNAME, DEFAULT_KEY_MANAGER);
        try {
            Class<?> cls = Class.forName(className);
            instance = (EncryptKeyManager)cls.newInstance();
        }
        catch (Exception e) {
            String msg = "can't find implement class for interface kd.bos.encrypt.keyManager ";
            log.error(msg, (Throwable)e);
            throw new EncryptException(msg, e);
        }
    }
}

