/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.key;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.Encrypters;
import kd.bos.encrypt.key.EncryptKeyManager;
import kd.bos.encrypt.util.EncryptProperties;
import kd.bos.util.StringUtils;

public class MCEncryptKeyManagerImpl
implements EncryptKeyManager {
    public static final String ENCRYPT_KEY = "kd.bos.encrypt.encryptKey";
    private static final String BUILTIN_RESOURCE = "/kd/bos/aes/aeskey.txt";
    private String ENCRYPT_VALUE = null;

    @Override
    public String getEncryptKey() {
        if (StringUtils.isNotEmpty((String)this.ENCRYPT_VALUE)) {
            return this.ENCRYPT_VALUE;
        }
        this.ENCRYPT_VALUE = this.getEncryptKeyByConfigFile();
        if (StringUtils.isNotEmpty((String)this.ENCRYPT_VALUE)) {
            return this.ENCRYPT_VALUE;
        }
        String keyFromZK = EncryptProperties.getWithEnv(ENCRYPT_KEY);
        this.ENCRYPT_VALUE = StringUtils.isNotEmpty((String)keyFromZK) ? Encrypters.decode(keyFromZK) : this.getKeyFromBuiltinResource();
        return this.ENCRYPT_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getKeyFromBuiltinResource() {
        try (InputStream in = this.getClass().getResourceAsStream(BUILTIN_RESOURCE);){
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String string = this.ENCRYPT_VALUE = br.readLine();
            return string;
        }
        catch (IOException e) {
            throw new EncryptException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEncryptKeyByConfigFile() {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream("/app.properties");){
            if (inputStream == null) return null;
            properties.load(inputStream);
            String encryptKey = properties.getProperty("encryptKey");
            if (!StringUtils.isNotEmpty((String)encryptKey)) return null;
            String string = encryptKey;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }
}

