/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.sm4;

import com.google.common.base.Charsets;
import java.io.IOException;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.key.EncryptKeyFactory;
import kd.bos.encrypt.sm4.SM4;
import kd.bos.encrypt.sm4.SM4Context;
import kd.bos.encrypt.sm4.SM4Encrypter;
import kd.bos.encrypt.sm4.SM4EncrypterLax;
import kd.bos.encrypt.util.EncryptProperties;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class SM4EncrypterImpl
implements SM4Encrypter {
    private static String SM4_ENCRYPT_LAX_IMPL = "kd.bos.encrypt.sm4.SM4EncrypterLaxImpl";
    private static final Object LOCKER = new Object();
    private static final Object LOCKER2 = new Object();
    private static final String SM4_DEFAULT_LENGTH = "128";
    private static final String SM4_KEY_LENGTH = "kd.bos.encrypt.keyLength";
    private static final String SM4_CIPHER_ALGORITHM = "kd.bos.encrypt.sm4Algorithm";
    private static final String DEFAULT_CIPHER_ALGORITHM = "CBC";
    private byte[] keyBytesFromCache;
    private byte[] ivBytesFromCache;
    private String sm4CipherAlgorithm = "CBC";
    private static boolean IV_MODE_RANDOM_FLAG;
    private static int ivLength;
    private static String SUFFIX_IV16;
    private SM4 cipher = null;

    public SM4EncrypterImpl() {
        IV_MODE_RANDOM_FLAG = EncryptKeyFactory.getEncrypterKeyManager().isRandomIV();
        ivLength = EncryptKeyFactory.getEncrypterKeyManager().getIvLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SM4 getCipherInstance() {
        if (this.cipher == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (this.cipher == null) {
                    this.initCipher();
                }
            }
        }
        return this.cipher;
    }

    private void initCipher() {
        try {
            this.sm4CipherAlgorithm = EncryptProperties.getWithEnv(SM4_CIPHER_ALGORITHM, DEFAULT_CIPHER_ALGORITHM);
            this.cipher = new SM4();
        }
        catch (Exception ex) {
            throw new EncryptException("Failed to create SM4Encrypt because the cipher initialization is failed, reason:", ex);
        }
    }

    private byte[] getSM4Key() {
        if (this.keyBytesFromCache != null) {
            return this.keyBytesFromCache;
        }
        String sm4Key = EncryptKeyFactory.getEncrypterKeyManager().getEncryptKey();
        String sm4KeyLengthFromZK = EncryptProperties.getWithEnv(SM4_KEY_LENGTH, SM4_DEFAULT_LENGTH);
        int sm4KeyLength = Integer.parseInt(sm4KeyLengthFromZK);
        if (StringUtils.isNotEmpty((String)sm4Key)) {
            byte[] key = this.getSM4KeyFromString(sm4Key, sm4KeyLength);
            this.keyBytesFromCache = key;
            return key;
        }
        throw new EncryptException("get encrypt key failed(encrypt key cannot be empty)");
    }

    private byte[] getSM4IV() {
        if (IV_MODE_RANDOM_FLAG) {
            return EncryptKeyFactory.getEncrypterKeyManager().getEncryptIvByte();
        }
        if (this.ivBytesFromCache != null) {
            return this.ivBytesFromCache;
        }
        byte[] iv = EncryptKeyFactory.getEncrypterKeyManager().getEncryptIvByte();
        this.ivBytesFromCache = iv;
        return iv;
    }

    @Override
    public String encrypt(String originalStr) throws EncryptException {
        try {
            byte[] key = this.getSM4Key();
            return this.encrypt(originalStr, key, this.getSM4IV());
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String decrypt(String encryptStr) throws EncryptException {
        try {
            byte[] key = this.getSM4Key();
            if (IV_MODE_RANDOM_FLAG) {
                return this.decrypt(encryptStr, key, null);
            }
            return this.decrypt(encryptStr, key, this.getSM4IV());
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String encrypt(String originalStr, String sm4Key, int length) throws EncryptException {
        try {
            byte[] key = this.getSM4KeyFromString(sm4Key, length);
            return this.encrypt(originalStr, key, key);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    @Override
    public String decrypt(String encryptStr, String sm4Key, int length) throws EncryptException {
        try {
            byte[] key = this.getSM4KeyFromString(sm4Key, length);
            return this.decrypt(encryptStr, key, key);
        }
        catch (Exception ex) {
            throw new EncryptException(ex);
        }
    }

    private byte[] getSM4KeyFromString(String str, int length) throws EncryptException {
        if (str == null || str.length() < length / 8) {
            throw new EncryptException("The given SM4 key or iv is too short.");
        }
        try {
            return str.substring(0, length / 8).getBytes(Charsets.UTF_8);
        }
        catch (Exception ex) {
            throw new EncryptException("An error has occurred when getting SM4 key:" + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encrypt(String originalStr, byte[] sm4Key, byte[] ivBytes) throws IOException {
        if (originalStr == null) {
            return null;
        }
        SM4Context ctx = new SM4Context();
        ctx.setPadding(true);
        ctx.setMode(1);
        SM4 sm4 = this.getCipherInstance();
        Object object = LOCKER2;
        synchronized (object) {
            byte[] encrypted;
            sm4.sm4_setkey_enc(ctx, sm4Key);
            if (DEFAULT_CIPHER_ALGORITHM.equals(this.sm4CipherAlgorithm)) {
                encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, originalStr.getBytes("UTF-8"));
                if (IV_MODE_RANDOM_FLAG) {
                    encrypted = SM4EncrypterImpl.joinIVAndData(ivBytes, encrypted);
                    return new String(Base64.encodeBase64((byte[])encrypted)) + SUFFIX_IV16;
                }
            } else {
                encrypted = this.getCacheSM4EncrypterLax().encrypt(originalStr, ctx, sm4);
            }
            return new String(Base64.encodeBase64((byte[])encrypted));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decrypt(String encryptStr, byte[] sm4Key, byte[] ivBytes) throws IOException {
        if (encryptStr == null) {
            return null;
        }
        String cipherText = encryptStr;
        SM4Context ctx = new SM4Context();
        ctx.setPadding(true);
        ctx.setMode(1);
        SM4 sm4 = this.getCipherInstance();
        Object object = LOCKER2;
        synchronized (object) {
            byte[] decrypted;
            sm4.sm4_setkey_dec(ctx, sm4Key);
            if (DEFAULT_CIPHER_ALGORITHM.equals(this.sm4CipherAlgorithm)) {
                if (IV_MODE_RANDOM_FLAG && this.isIv16ModeRandomData(cipherText)) {
                    cipherText = cipherText.substring(0, cipherText.lastIndexOf(SUFFIX_IV16));
                    byte[] ivAndData = Base64.decodeBase64((String)cipherText);
                    byte[] iv = new byte[ivLength];
                    byte[] data = new byte[ivAndData.length - ivLength];
                    System.arraycopy(ivAndData, 0, iv, 0, ivLength);
                    System.arraycopy(ivAndData, ivLength, data, 0, data.length);
                    decrypted = sm4.sm4_crypt_cbc(ctx, iv, data);
                } else {
                    decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
                }
            } else {
                decrypted = this.getCacheSM4EncrypterLax().decrypt(Base64.decodeBase64((String)cipherText), ctx, sm4);
            }
            return new String(decrypted, "UTF-8");
        }
    }

    private boolean isIv16ModeRandomData(String encryptStr) {
        return encryptStr.endsWith(SUFFIX_IV16);
    }

    private static byte[] joinIVAndData(byte[] ivByte, byte[] data) {
        byte[] r = new byte[ivByte.length + data.length];
        System.arraycopy(ivByte, 0, r, 0, ivByte.length);
        System.arraycopy(data, 0, r, ivByte.length, data.length);
        return r;
    }

    private SM4EncrypterLax getCacheSM4EncrypterLax() {
        return SM4EncrypterLaxHolder.sm4EncrypterLax;
    }

    static {
        SUFFIX_IV16 = EncryptProperties.getWithEnv("kd.bos.encrypt.sm4.suffix", "#s*16");
    }

    private static class SM4EncrypterLaxHolder {
        private static SM4EncrypterLax sm4EncrypterLax;

        private SM4EncrypterLaxHolder() {
        }

        static {
            try {
                sm4EncrypterLax = (SM4EncrypterLax)Class.forName(SM4_ENCRYPT_LAX_IMPL).newInstance();
            }
            catch (Exception e) {
                throw new EncryptException(e);
            }
        }
    }
}

