/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class BeanUtils {
    private static final ConcurrentMap<String, Class<?>> typesDictionary = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Object> instanceDictionary = new ConcurrentHashMap();

    private static Class<?> getBeanClass(String clz) {
        if (clz == null || clz.isEmpty()) {
            throw new IllegalArgumentException("Failed to get name of type.");
        }
        Class<?> tp = (Class<?>)typesDictionary.get(clz.trim());
        if (tp == null) {
            try {
                tp = Class.forName(clz.trim());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Type %s not found.", clz), e);
            }
            typesDictionary.put(clz, tp);
        }
        return tp;
    }

    public static <T> T getBean(String clz) {
        Class<?> tp = BeanUtils.getBeanClass(clz.trim());
        Object ins = instanceDictionary.get(tp);
        if (ins == null) {
            try {
                ins = tp.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(String.format("Failed to initialize type %s .", clz), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Failed to access type %s .", clz), e);
            }
            instanceDictionary.put(tp, ins);
        }
        return (T)ins;
    }
}

