/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import kd.bos.encrypt.api.FrameWorkServiceFactory;
import kd.bos.encrypt.pass.PasswordEncoder;
import kd.bos.encrypt.pass.PasswordFactory;
import kd.bos.util.EncryptUtils;
import kd.bos.util.HexUtils;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordEncryptUtil {
    private static Logger LOG = LoggerFactory.getLogger(PasswordEncryptUtil.class);
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int SALT_BYTE_SIZE = 16;
    public static final int HASH_BIT_SIZE = 512;
    public static final int PBKDF2_ITERATIONS = 1000;
    private static final int PASSWORD_CHECK_LENGTH = 160;

    public static boolean authenticate(String attemptedPassword, String encryptedPassword, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String encryptedAttemptedPassword = PasswordFactory.getPasswordEncoder(encryptedPassword).encryptPassword(attemptedPassword, salt);
        return encryptedAttemptedPassword.equals(encryptedPassword);
    }

    public static String getCorrectUserIDSalt(String uid) {
        String returnValue = uid;
        if (StringUtils.isNotEmpty((String)uid) && uid.length() <= 1) {
            returnValue = uid + "110111";
        }
        return returnValue;
    }

    public static String getEncryptedPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PasswordEncoder encoder = PasswordFactory.getCurrentUsingPasswordEncoder();
        return encoder.encryptPassword(password, salt);
    }

    public static String generateSalt() throws NoSuchAlgorithmException {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException var2) {
            LOG.info(var2.getMessage());
        }
        if (random == null) {
            random = new SecureRandom();
        }
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return HexUtils.toHex(salt);
    }

    public static String getEncryptePasswordWithSalt(String password, String salt) {
        String returnPass = "";
        try {
            returnPass = PasswordEncryptUtil.getEncryptedPassword(password, salt);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            LOG.error(e.getMessage());
        }
        return returnPass;
    }

    public static String getEncryptePasswordWithSalt(String password) {
        String returnPass = "";
        try {
            String salt = PasswordEncryptUtil.generateSalt();
            String ciphertext = PasswordEncryptUtil.getEncryptedPassword(password, salt);
            returnPass = ciphertext + salt;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            LOG.error(e.getMessage());
        }
        return returnPass;
    }

    public static boolean authenticate(String oldPassword, String newPassword) {
        String salt = PasswordEncryptUtil.getSalt(oldPassword);
        return PasswordEncryptUtil.authenticateWithSalt(salt, oldPassword, newPassword);
    }

    public static boolean authenticateWithSalt(String salt, String oldPassword, String newPassword) {
        boolean passed = false;
        if (oldPassword != null) {
            String realSalt = salt;
            String encrytedString = oldPassword;
            if (oldPassword.length() >= 160) {
                realSalt = PasswordEncryptUtil.getSalt(oldPassword);
                encrytedString = PasswordEncryptUtil.getEncryptedString(oldPassword, realSalt);
            } else {
                encrytedString = oldPassword;
            }
            try {
                if (StringUtils.isNotEmpty((String)realSalt)) {
                    String ciphertext = PasswordFactory.getPasswordEncoder(oldPassword).encryptPassword(newPassword, realSalt);
                    passed = encrytedString.equals(ciphertext);
                }
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error(e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                LOG.error(e.getMessage());
            }
        }
        return passed;
    }

    private static String getEncryptedString(String oldPassword, String salt) {
        String returnValue = "";
        if (oldPassword != null && salt != null) {
            returnValue = oldPassword.replace(salt, "");
        }
        return returnValue;
    }

    private static String getSalt(String oldPassword) {
        String salt = "";
        if (oldPassword != null && oldPassword.length() >= 160) {
            salt = oldPassword.substring(oldPassword.length() - 32, oldPassword.length());
        }
        return salt;
    }

    public static boolean checkPassword(String password, String oldPassword) {
        boolean passed = false;
        if (password != null && oldPassword != null) {
            if (PasswordEncryptUtil.authenticate(oldPassword, password)) {
                passed = true;
            }
            if (PasswordEncryptUtil.supportOLDEncrypt() && !passed && oldPassword.equals(EncryptUtils.encryptPSW(password))) {
                passed = true;
            }
        }
        return passed;
    }

    private static boolean supportOLDEncrypt() {
        boolean supportOLDEncrypt = true;
        String supporString = FrameWorkServiceFactory.getFrameWorkService().geStringtProptyOfTenant("password_support_old_arlgorithm");
        if (StringUtils.isNotEmpty((String)supporString) && !"true".equalsIgnoreCase(supporString)) {
            supportOLDEncrypt = false;
        }
        return supportOLDEncrypt;
    }

    public static boolean checkPasswordWithSalt(String salt, String password, String oldPassword) {
        boolean passed = false;
        if (password != null && oldPassword != null) {
            if (StringUtils.isNotEmpty((String)salt)) {
                passed = PasswordEncryptUtil.authenticateWithSalt(salt, oldPassword, password);
            }
            if (PasswordEncryptUtil.supportOLDEncrypt() && !passed && oldPassword.equals(EncryptUtils.encryptPSW(password))) {
                passed = true;
            }
        }
        return passed;
    }
}

