/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.autoact.agent.AgentBuilder;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.AgentContextImpl;
import kd.bos.gptas.autoact.agent.AgentInvoker;
import kd.bos.gptas.autoact.agent.AgentProxy;
import kd.bos.gptas.autoact.agent.ExternalToolBuilder;
import kd.bos.gptas.autoact.agent.listener.AgentListener;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.llm.ChatModelFactory;
import kd.bos.gptas.autoact.memory.ChatMemory;
import kd.bos.gptas.autoact.memory.MaxWindowChatMemory;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.AgentImpl;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.prompt.Prompt;
import kd.bos.gptas.autoact.prompt.loader.PromptLoader;
import kd.bos.gptas.autoact.prompt.var.ContextVarProvider;
import kd.bos.gptas.autoact.prompt.var.MapVarProvider;
import kd.bos.gptas.autoact.prompt.var.VarProvider;
import kd.bos.gptas.autoact.util.StringUtil;

final class AgentBuilderImpl<T>
implements AgentBuilder<T> {
    private final AgentContext ctx;
    private final List<Map<String, Object>> refineList = new ArrayList<Map<String, Object>>();
    private String modelPath;
    private VarProvider agentVarProvider;

    public AgentBuilderImpl(Class<T> agentClass, VarProvider agentScopeVarProvider) {
        this.ctx = new AgentContextImpl(agentClass);
        this.agentVarProvider = agentScopeVarProvider;
        Agent agent = agentClass.getAnnotation(Agent.class);
        this.modelPath = Agent.Paths.get(agent, agentClass);
    }

    @Override
    public T build() {
        String template;
        if (this.ctx.getChatModel() == null) {
            this.llm(ChatModelFactory.get().createDefaultModel());
        }
        if (this.ctx.getMemory() == null) {
            this.memory(new MaxWindowChatMemory());
        }
        if (this.agentVarProvider == null) {
            this.agentVarProvider = new MapVarProvider(new HashMap<String, Object>());
        }
        this.agentVarProvider = new ContextVarProvider(this.agentVarProvider, this.ctx);
        if (StringUtil.isEmpty(this.modelPath)) {
            String name = Agent.Names.getAgentName(((AgentContextImpl)this.ctx).getAgentClass());
            template = "{\"name\":\"" + name + "\"}";
        } else {
            template = PromptLoader.get().loadAlternative(this.modelPath, this.ctx.getChatModel().name());
        }
        ((AgentContextImpl)this.ctx).buildAgentModel(new Prompt(template, this.agentVarProvider), this.refineList);
        Object agentInstance = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.ctx.getAgent().getAgentClass(), AgentProxy.class}, (InvocationHandler)new AgentInvoker(this.ctx));
        ((AgentImpl)this.ctx.getAgent()).setAgentInstance((AgentProxy)agentInstance);
        return (T)agentInstance;
    }

    @Override
    public AgentBuilder<T> verbose(boolean verbose) {
        this.ctx.setVerbose(verbose);
        return this;
    }

    @Override
    public AgentBuilder<T> debugMessageStream(boolean b) {
        this.ctx.setDebugMessageStream(b);
        return this;
    }

    @Override
    public AgentBuilder<T> llm(ChatModel chatModel) {
        ((AgentContextImpl)this.ctx).setChatModel(chatModel);
        return this;
    }

    @Override
    public AgentBuilder<T> model(String modelPath) {
        this.modelPath = modelPath;
        return this;
    }

    @Override
    public AgentBuilder<T> memory(ChatMemory memory) {
        this.ctx.setMemory(memory);
        return this;
    }

    @Override
    public AgentBuilder<T> tools(Tool ... tools) {
        this.ctx.addTools(tools);
        return this;
    }

    @Override
    public AgentBuilder<T> refine(Map<String, Object> agentModel) {
        this.refineList.add(agentModel);
        return this;
    }

    @Override
    public AgentBuilder<T> agentAsTool(Object agentObject) {
        this.ctx.addAgentAsTool(agentObject);
        return this;
    }

    @Override
    public AgentBuilder<T> action(String name, Action action) {
        this.ctx.setAction(name, action);
        return this;
    }

    @Override
    public AgentBuilder<T> externalToolBuilder(ExternalToolBuilder externalToolBuilder) {
        ((AgentContextImpl)this.ctx).setExternalToolBuilder(externalToolBuilder);
        return this;
    }

    @Override
    public AgentBuilder<T> addAgentListeners(AgentListener ... listeners) {
        ((AgentContextImpl)this.ctx).addAgentListener(listeners);
        return this;
    }
}

