/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.Agents;
import kd.bos.gptas.autoact.agent.ExternalToolBuilder;
import kd.bos.gptas.autoact.agent.callchain.AgentCallChain;
import kd.bos.gptas.autoact.agent.callchain.AgentCallChainImpl;
import kd.bos.gptas.autoact.agent.executor.AgentExecutor;
import kd.bos.gptas.autoact.agent.listener.AgentListener;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.def.Tool;
import kd.bos.gptas.autoact.exception.AgentDefineError;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.llm.ChatModelFactory;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.memory.ChatMemory;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.Agent;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.prompt.Prompt;
import kd.bos.gptas.autoact.prompt.var.ContextVarProvider;
import kd.bos.gptas.autoact.prompt.var.MixedVarProvider;
import kd.bos.gptas.autoact.prompt.var.VarProvider;
import kd.bos.gptas.autoact.session.AgentSession;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.autoact.util.StringUtil;

public final class AgentContextImpl
implements AgentContext,
Logable {
    private final Class<?> agentClass;
    private boolean debugMessageSteam = false;
    private boolean verbose = true;
    private ChatModel chatModel;
    private Prompt prompt;
    private ChatMemory memory;
    private final List<Tool> internalTools = new ArrayList<Tool>();
    private final List<Tool> externalTools = new ArrayList<Tool>();
    private final List<Tool> userAddedTools = new ArrayList<Tool>();
    private final AgentExecutor executor = new AgentExecutor(this);
    private Agent agent;
    private final Map<String, Action> actionMap = new HashMap<String, Action>();
    private boolean _toolsChanged = false;
    private final Map<String, Tool> _toolMap = new HashMap<String, Tool>();
    private List<Tool> _allTools = new ArrayList<Tool>();
    private AgentContextImpl parent;
    private AgentSession agentSession;
    private ExternalToolBuilder externalToolBuilder;
    private final List<AgentListener> listeners = new ArrayList<AgentListener>();
    private AgentCallChain callChain;
    private ContextVarProvider allContextVarProvider = null;

    AgentContextImpl(Class<?> agentClass) {
        if (!agentClass.isInterface()) {
            throw new AgentDefineError(agentClass.getName() + " is not an interface.");
        }
        this.agentClass = agentClass;
    }

    @Override
    public AgentSession getSession() {
        if (this.parent == null) {
            if (this.agentSession == null) {
                this.agentSession = AgentSession.create(this);
            }
            return this.agentSession;
        }
        return this.parent.getSession();
    }

    @Override
    public AgentCallChain getCallChain() {
        if (this.parent == null) {
            if (this.callChain == null) {
                this.callChain = new AgentCallChainImpl();
            }
            return this.callChain;
        }
        return this.parent.getCallChain();
    }

    @Override
    public int getLevel() {
        int level = 0;
        AgentContextImpl ctx = this.parent;
        while (ctx != null) {
            ++level;
            ctx = ctx.parent;
        }
        return level;
    }

    @Override
    public AgentContext getParent() {
        return this.parent;
    }

    public void setParent(AgentContext parent) {
        if (this.parent != parent) {
            this.parent = (AgentContextImpl)parent;
            this.agentSession = parent.getSession();
        }
    }

    public AgentExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isDebugMessageStream() {
        return this.debugMessageSteam;
    }

    @Override
    public void setDebugMessageStream(boolean b) {
        this.debugMessageSteam = b;
    }

    @Override
    public ChatModel getChatModel() {
        return this.chatModel;
    }

    void setChatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
    }

    public void setAction(String name, Action action) {
        this.actionMap.put(name, action);
    }

    public Action getAction(String name) {
        return this.actionMap.get(name);
    }

    public Class<?> getAgentClass() {
        return this.agentClass;
    }

    @Override
    public ContextVarProvider getContextVarProvider() {
        if (this.parent != null) {
            if (this.allContextVarProvider == null) {
                this.allContextVarProvider = new ContextVarProvider((VarProvider)new MixedVarProvider(this.getPrompt().getVarProvider(), this.parent.getContextVarProvider()), this);
            }
            return this.allContextVarProvider;
        }
        return (ContextVarProvider)this.getPrompt().getVarProvider();
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    void buildAgentModel(Prompt prompt, List<Map<String, Object>> refineList) {
        String llm;
        this.prompt = prompt;
        ArrayList<JSONObject> jsonDefinitions = new ArrayList<JSONObject>(4);
        jsonDefinitions.add(JsonUtil.parseObject(prompt.getTemplate()));
        for (Map<String, Object> refine : refineList) {
            if (refine instanceof JSONObject) {
                jsonDefinitions.add((JSONObject)refine);
                continue;
            }
            jsonDefinitions.add(new JSONObject(refine));
        }
        this.agent = Agent.from(this.agentClass, jsonDefinitions.toArray(new JSONObject[jsonDefinitions.size()]));
        if (StringUtil.isEmpty(this.agent.getName())) {
            this.agent.setName(Agent.Names.getAgentName(this.agentClass));
        }
        if (!((llm = this.agent.getLlm()) == null || llm.isEmpty() || this.chatModel != null && llm.equals(this.chatModel.name()))) {
            this.setChatModel(ChatModelFactory.get().createModel(llm));
        }
        this.internalTools.clear();
        this.internalTools.addAll(this.agent.getInternalTools());
        this.externalTools.clear();
        for (String toolPath : this.agent.getExternalTools()) {
            Tool tool = Tool.Builder.buildExternalTool(toolPath, this.chatModel, this);
            this.externalTools.add(tool);
        }
        this._toolsChanged = true;
    }

    @Override
    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public ChatMemory getMemory() {
        return this.memory;
    }

    @Override
    public void setMemory(ChatMemory memory) {
        this.memory = memory;
    }

    @Override
    public List<Tool> getInternalTools() {
        return Collections.unmodifiableList(this.internalTools);
    }

    @Override
    public List<Tool> getExternalTools() {
        return Collections.unmodifiableList(this.externalTools);
    }

    @Override
    public Tool getTool(String name) {
        this.flushToolsState();
        return this._toolMap.get(name);
    }

    @Override
    public void addAgentAsTool(Object agentInstance) {
        this.userAddedTools.add(Agents.getAgentContext(agentInstance).getAgent().asTool());
        this._toolsChanged = true;
    }

    @Override
    public void addTools(Tool ... tools) {
        if (tools != null) {
            this.userAddedTools.addAll(Arrays.asList(tools));
            this._toolsChanged = true;
        }
    }

    @Override
    public List<Tool> getAllTools() {
        this.flushToolsState();
        return Collections.unmodifiableList(this._allTools);
    }

    @Override
    public ExternalToolBuilder getExternalToolBuilder() {
        if (this.parent == null) {
            return this.externalToolBuilder;
        }
        return this.parent.getExternalToolBuilder();
    }

    void setExternalToolBuilder(ExternalToolBuilder externalToolBuilder) {
        if (this.parent == null) {
            this.externalToolBuilder = externalToolBuilder;
        } else {
            this.parent.setExternalToolBuilder(externalToolBuilder);
        }
    }

    @Override
    public List<AgentListener> getAgentListeners() {
        if (this.parent == null) {
            return Collections.unmodifiableList(this.listeners);
        }
        return this.parent.getAgentListeners();
    }

    void addAgentListener(AgentListener ... listeners) {
        if (this.parent == null) {
            if (listeners != null) {
                for (AgentListener listener : listeners) {
                    if (listener == null) continue;
                    this.listeners.add(listener);
                }
            }
        } else {
            this.parent.addAgentListener(listeners);
        }
    }

    private void flushToolsState() {
        if (this._toolsChanged) {
            ArrayList<Tool> tools = new ArrayList<Tool>(16);
            HashSet<String> nameSet = new HashSet<String>(16);
            for (Tool tool : this.internalTools) {
                if (nameSet.add(tool.getName())) {
                    tools.add(tool);
                    continue;
                }
                logger.warn("Duplicate internal tool name #" + tool.getName() + ", will use the first defined.");
            }
            for (Tool tool : this.externalTools) {
                if (nameSet.add(tool.getName())) {
                    tools.add(tool);
                    continue;
                }
                logger.warn("Duplicate external tool name #" + tool.getName() + ", will use the first defined.");
            }
            for (Tool tool : this.userAddedTools) {
                if (nameSet.add(tool.getName())) {
                    tools.add(tool);
                    continue;
                }
                logger.warn("Duplicate user added tool name #" + tool.getName() + ", will use the first defined.");
            }
            this._toolMap.clear();
            for (Tool tool : tools) {
                this._toolMap.put(tool.getName(), tool);
            }
            this._allTools = tools;
            this._toolsChanged = false;
        }
    }

    public void fireAgentListener(Consumer<AgentListener> listenerConsumer) {
        List<AgentListener> listeners = this.getAgentListeners();
        if (!listeners.isEmpty()) {
            for (AgentListener listener : listeners) {
                listenerConsumer.accept(listener);
            }
        }
    }
}

