/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.executor;

import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.output.convert.LLMConverter;
import kd.bos.gptas.autoact.util.JsonUtil;

public final class InvokeData
implements Logable {
    private static final String SINGLE_VALUE_KEY = "__input__";
    private final Map<String, Object> dataWrapper = new HashMap<String, Object>();

    public static InvokeData fromArguments(Tool methodTool, Object[] values) {
        return InvokeData.fromArguments(methodTool.getParameterNames(), values);
    }

    public static InvokeData fromArguments(String[] names, Object[] values) {
        if (names.length != values.length) {
            throw new IllegalArgumentException("The number of argument names and values does not match(Names: " + Arrays.toString(names) + ", Values:" + Arrays.toString(values) + ").");
        }
        InvokeData data = new InvokeData();
        int i = 0;
        for (String name : names) {
            data.put(name, values[i++]);
        }
        return data;
    }

    public static InvokeData fromResult(Object value) {
        if (value instanceof InvokeData) {
            return (InvokeData)value;
        }
        InvokeData data = new InvokeData();
        data.setSingleValue(value);
        return data;
    }

    private InvokeData() {
    }

    public void put(String key, Object value) {
        this.dataWrapper.put(key, value);
    }

    public void putAll(Map<String, Object> map) {
        this.dataWrapper.putAll(map);
    }

    public Object get(String key) {
        return this.dataWrapper.get(key);
    }

    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.dataWrapper);
    }

    public boolean isSingleValue() {
        return this.dataWrapper.size() == 1;
    }

    public void setSingleValue(Object value) {
        this.put(SINGLE_VALUE_KEY, value);
    }

    public Object getSingleValue() {
        return this.dataWrapper.values().iterator().next();
    }

    public String toString() {
        return this.isSingleValue() ? String.valueOf(this.getSingleValue()) : JsonUtil.toJSONString(this.dataWrapper, new SerializerFeature[0]);
    }

    public Object[] toArguments(String[] argumentNames, Class<?>[] argumentTypes, AgentContext ctx) {
        if (argumentNames.length != argumentTypes.length) {
            throw new IllegalArgumentException("The number of argument names and values does not match(Names: " + Arrays.toString(argumentNames) + ", Values:" + Arrays.toString(argumentTypes) + ").");
        }
        Object[] ret = new Object[argumentNames.length];
        for (int i = 0; i < argumentNames.length; ++i) {
            ret[i] = LLMConverter.convert(this.get(argumentNames[i]), argumentTypes[i], ctx);
        }
        return ret;
    }

    public <T> T toArgument(Class<T> parameterType, AgentContext ctx) {
        return this.toReturn(parameterType, ctx);
    }

    public <T> T toReturn(Class<T> returnType, AgentContext ctx) {
        if (this.isSingleValue()) {
            return LLMConverter.convert(this.getSingleValue(), returnType, ctx);
        }
        return LLMConverter.convert(this.dataWrapper, returnType, ctx);
    }
}

