/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.agent.reflect;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.gptas.autoact.agent.reflect.AgentReflectInfo;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.exception.AgentDefineError;
import kd.bos.gptas.autoact.prompt.loader.PromptLoader;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.autoact.util.LRUCacheMap;
import kd.bos.gptas.autoact.util.StringUtil;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

public final class AgentScanner {
    public static final String DEFAULT_SCAN_PACKAGES = System.getProperty("agent_default_scan_packages", "kd.");
    private static final String ALL_PACKAGE = "";
    private static Map<String, Object> lockMap = new ConcurrentHashMap<String, Object>();
    private static Map<String, List<AgentReflectInfo>> agentListMap = new LRUCacheMap<String, List<AgentReflectInfo>>(512);
    private static Map<String, AgentReflectInfo> agentMap = new ConcurrentHashMap<String, AgentReflectInfo>();
    private static Set<String> agentNameSet;

    public static AgentReflectInfo getAgentReflectInfo(String name) {
        AgentReflectInfo agent = agentMap.get(name);
        if (agent == null) {
            AgentScanner.scanDefault();
            agent = agentMap.get(name);
            if (agent == null) {
                AgentScanner.scanAll();
                agent = agentMap.get(name);
            }
        }
        return agent;
    }

    public synchronized Set<String> getAllAgentNames() {
        if (agentNameSet == null) {
            agentNameSet = new HashSet<String>();
            AgentScanner.scanAll();
            for (AgentReflectInfo info : agentMap.values()) {
                agentNameSet.add(info.getName());
            }
        }
        agentNameSet = Collections.unmodifiableSet(agentNameSet);
        return agentNameSet;
    }

    public static List<AgentReflectInfo> scanDefault() {
        return AgentScanner.scan(DEFAULT_SCAN_PACKAGES);
    }

    public static List<AgentReflectInfo> scanAll() {
        return AgentScanner.scan(ALL_PACKAGE);
    }

    private static List<AgentReflectInfo> scan(String ... packages) {
        String key = AgentScanner.genKey(packages);
        List<AgentReflectInfo> ret = agentListMap.get(key);
        if (ret != null) {
            return ret;
        }
        if (ALL_PACKAGE.equals(key)) {
            return AgentScanner.doScan(ALL_PACKAGE);
        }
        List<AgentReflectInfo> all = agentListMap.get(ALL_PACKAGE);
        if (all == null) {
            return AgentScanner.doScan(packages);
        }
        HashSet<String> pkSet = new HashSet<String>();
        for (String pk : packages) {
            if (StringUtil.isEmpty(pk)) continue;
            if (!pk.endsWith(".")) {
                pk = pk + ".";
            }
            pkSet.add(pk);
        }
        ret = new ArrayList<AgentReflectInfo>();
        for (AgentReflectInfo item : all) {
            AgentReflectInfo info = agentMap.get(item.getName());
            String agentPK = info.getAgentClass().getName();
            for (String pk : pkSet) {
                if (!agentPK.startsWith(pk)) continue;
                ret.add(item);
            }
        }
        return ret;
    }

    private static String genKey(String ... packages) {
        return packages == null || packages.length == 0 || packages.length == 1 && StringUtil.isEmpty(packages[0]) ? ALL_PACKAGE : Arrays.asList(packages).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<AgentReflectInfo> doScan(String ... packages) {
        String key = AgentScanner.genKey(packages);
        List<AgentReflectInfo> ret = agentListMap.get(key);
        if (ret == null) {
            Object lock;
            Object object = lock = lockMap.computeIfAbsent(key, k -> new Object());
            synchronized (object) {
                ret = agentListMap.get(key);
                if (ret == null) {
                    ret = new ArrayList<AgentReflectInfo>(16);
                    Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(packages).filterInputsBy(file -> file.endsWith(".class")).setScanners(new Scanner[]{Scanners.TypesAnnotated}));
                    TreeSet<Class> set = new TreeSet<Class>(Comparator.comparing(Class::getName));
                    set.addAll(reflections.getTypesAnnotatedWith(Agent.class));
                    for (Class agentClass : set) {
                        kd.bos.gptas.autoact.model.Agent agent;
                        Agent anAgent = agentClass.getAnnotation(Agent.class);
                        if (anAgent == null) continue;
                        String modelPath = Agent.Paths.get(anAgent, agentClass);
                        if (!StringUtil.isEmpty(modelPath)) {
                            String template = PromptLoader.get().loadAlternative(modelPath, null);
                            JSONObject jsonObject = JsonUtil.parseObject(template);
                            agent = kd.bos.gptas.autoact.model.Agent.from(agentClass, jsonObject);
                        } else {
                            agent = kd.bos.gptas.autoact.model.Agent.from(agentClass, new JSONObject[0]);
                        }
                        AgentReflectInfo info = AgentReflectInfo.from(agent);
                        ret.add(info);
                        try {
                            Agent.Names.checkDefinedByAgentAPI(agent.getName());
                        }
                        catch (AgentDefineError e) {
                            throw new AgentDefineError(e.getMessage() + " @" + agent.getAgentClass().getName(), e);
                        }
                        agentMap.put(agent.getName(), info);
                    }
                    agentListMap.put(key, ret);
                }
            }
        }
        return ret;
    }
}

