/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.def;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.AgentContextImpl;
import kd.bos.gptas.autoact.agent.Agents;
import kd.bos.gptas.autoact.agent.ExternalToolBuilder;
import kd.bos.gptas.autoact.agent.reflect.AgentReflectInfo;
import kd.bos.gptas.autoact.agent.reflect.AgentScanner;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.def.KV;
import kd.bos.gptas.autoact.exception.AgentDefineError;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.model.ActionModel;
import kd.bos.gptas.autoact.model.BeforeOrAfterActionModel;
import kd.bos.gptas.autoact.output.ReturnType;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface Tool {
    public String name() default "";

    public String[] intentPrompt() default {""};

    public String[] actionPrompt() default {""};

    public ActionModel actionModel() default ActionModel.ACTION;

    public ReturnType returnType() default ReturnType.AUTO;

    public boolean export() default true;

    public String[] beforeActionTools() default {};

    public String[] afterActionTools() default {};

    public BeforeOrAfterActionModel beforeActionModel() default BeforeOrAfterActionModel.FLOW;

    public BeforeOrAfterActionModel afterActionModel() default BeforeOrAfterActionModel.FLOW;

    public KV[] input() default {};

    public KV[] properties() default {};

    public static class Builder {
        public static kd.bos.gptas.autoact.model.Tool buildExternalTool(String toolName, ChatModel chatModel, AgentContext parentContext) {
            Object agentInstance = null;
            AgentReflectInfo info = AgentScanner.getAgentReflectInfo(toolName);
            if (info == null) {
                Optional<Object> opt;
                ExternalToolBuilder builder = parentContext.getExternalToolBuilder();
                if (builder != null && (opt = builder.buildAgentInstance(toolName)).isPresent()) {
                    agentInstance = opt.get();
                }
                if (agentInstance == null) {
                    throw new AgentDefineError("external tool not found: " + toolName);
                }
                try {
                    Agent.Names.checkDefinedBySkillConfig(toolName);
                }
                catch (AgentDefineError e) {
                    throw new AgentDefineError(e.getMessage() + " @" + Agents.getAgentContext(agentInstance).getAgent().getAgentClass().getName(), e);
                }
            }
            try {
                Agent.Names.checkDefinedByAgentAPI(toolName);
            }
            catch (AgentDefineError e) {
                throw new AgentDefineError(e.getMessage() + " @" + info.getAgentClass().getName());
            }
            agentInstance = Agents.builder(info.getAgentClass()).llm(chatModel).build();
            AgentContextImpl ctx = (AgentContextImpl)Agents.getAgentContext(agentInstance);
            ctx.setParent(parentContext);
            return (kd.bos.gptas.autoact.model.Tool)((Object)ctx.getAgent());
        }
    }
}

