/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.memory;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.gptas.autoact.memory.AbstractChatMemory;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.message.ChatMessageType;

public class MaxCharacterChatMemory
extends AbstractChatMemory {
    private final int maxCharacters;
    private List<ChatMessage> messageList = new LinkedList<ChatMessage>();
    private int characters = 0;

    public MaxCharacterChatMemory() {
        this(4096);
    }

    public MaxCharacterChatMemory(int maxCharacters) {
        if (maxCharacters < 4096) {
            maxCharacters = 4096;
        }
        this.maxCharacters = maxCharacters;
    }

    @Override
    public void add(ChatMessage message, boolean lastReturn) {
        super.add(message, lastReturn);
        this.messageList.add(message);
        this.characters += lastReturn ? message.getMessageText().length() : message.getMessage().length();
        while (this.characters > this.maxCharacters) {
            ChatMessage removed = this.messageList.get(0).getType() == ChatMessageType.SYSTEM ? this.messageList.remove(1) : this.messageList.remove(0);
            this.characters -= removed.getMessage().length();
        }
    }

    @Override
    public List<ChatMessage> messages() {
        return Collections.unmodifiableList(this.messageList);
    }

    @Override
    public void clear() {
        super.clear();
        this.messageList.clear();
        this.characters = 0;
    }
}

