/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.memory;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.gptas.autoact.memory.AbstractChatMemory;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.message.ChatMessageType;

public class MaxWindowChatMemory
extends AbstractChatMemory {
    private final int maxMessages;
    private List<ChatMessage> messageList = new LinkedList<ChatMessage>();

    public MaxWindowChatMemory() {
        this(10);
    }

    public MaxWindowChatMemory(int maxMessages) {
        this.maxMessages = maxMessages < 1 ? 1 : maxMessages;
    }

    @Override
    public void add(ChatMessage message, boolean lastReturn) {
        super.add(message, lastReturn);
        this.messageList.add(message);
        while (this.messageList.size() > this.maxMessages) {
            if (this.messageList.get(0).getType() == ChatMessageType.SYSTEM) {
                this.messageList.remove(1);
                continue;
            }
            this.messageList.remove(0);
        }
    }

    @Override
    public List<ChatMessage> messages() {
        return Collections.unmodifiableList(this.messageList);
    }

    @Override
    public void clear() {
        super.clear();
        this.messageList.clear();
    }
}

