/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.message;

import kd.bos.gptas.autoact.message.BufferedMessageStream;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.message.ChatMessageType;
import kd.bos.gptas.autoact.message.MessageStream;

public class BaseChatMessage
implements ChatMessage {
    private final ChatMessageType type;
    private MessageStream messageStream;
    private String message;
    private final boolean streaming;

    protected BaseChatMessage(ChatMessageType type, String message) {
        this.type = type;
        this.message = message;
        this.streaming = false;
    }

    protected BaseChatMessage(ChatMessageType type, MessageStream messageStream) {
        this.type = type;
        this.messageStream = messageStream;
        this.streaming = true;
    }

    @Override
    public String getMessageText() {
        if (this.message != null) {
            return this.message;
        }
        if (this.messageStream != null) {
            this.message = this.messageStream.fetch();
            this.messageStream = null;
        }
        return this.message;
    }

    @Override
    public MessageStream getMessageStream() {
        if (this.messageStream != null) {
            return this.messageStream;
        }
        if (this.message != null) {
            this.messageStream = new BufferedMessageStream(this.message);
            this.message = null;
        }
        return this.messageStream;
    }

    @Override
    public boolean isStream() {
        return this.streaming;
    }

    @Override
    public ChatMessageType getType() {
        return this.type;
    }

    public String toString() {
        return (Object)((Object)this.type) + ": " + (this.messageStream == null ? this.message : this.messageStream);
    }
}

