/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.executor.InvokeData;
import kd.bos.gptas.autoact.model.ActionModel;
import kd.bos.gptas.autoact.model.Agent;
import kd.bos.gptas.autoact.model.BeforeOrAfterActionModel;
import kd.bos.gptas.autoact.model.Parameter;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.model.ToolInput;
import kd.bos.gptas.autoact.output.ReturnType;
import kd.bos.gptas.autoact.prompt.Prompt;
import kd.bos.gptas.autoact.prompt.PromptBuilder;
import kd.bos.gptas.autoact.prompt.var.MapVarProvider;
import kd.bos.gptas.autoact.prompt.var.MixedVarProvider;
import kd.bos.gptas.autoact.prompt.var.VarProvider;
import kd.bos.gptas.autoact.util.StringUtil;

public class ToolImpl
implements Tool {
    public static final String EXPORT = "export";
    public static final String NAME = "name";
    public static final String ACTION_PROMPT = "action_prompt";
    public static final String INTENT_PROMPT = "intent_prompt";
    public static final String RETURN_TYPE = "return_type";
    public static final String PARAMETERS = "parameters";
    public static final String ACTION = "action";
    public static final String ACTION_MODEL = "action_model";
    public static final String BEFORE_ACTION_TOOLS = "before_action_tools";
    public static final String AFTER_ACTION_TOOLS = "after_action_tools";
    public static final String BEFORE_ACTION_MODEL = "before_action_model";
    public static final String AFTER_ACTION_MODEL = "after_action_model";
    public static final String PROPERTIES = "properties";
    public static final String INPUT = "input";
    private boolean export;
    private String name;
    private String actionPrompt;
    private String intentPrompt;
    private ReturnType returnType;
    private ActionModel actionModel;
    protected final List<Parameter> parameters = new ArrayList<Parameter>();
    private final Map<String, Object> properties = new TreeMap<String, Object>();
    private final Map<String, String> input = new TreeMap<String, String>();
    private String action;
    protected final List<String> beforeActionTools = new ArrayList<String>();
    protected final List<String> afterActionTools = new ArrayList<String>();
    private BeforeOrAfterActionModel beforeActionModel;
    private BeforeOrAfterActionModel afterActionModel;

    static <T extends Tool> void merge(JSONObject jsonObject, T tool) {
        JSONArray params;
        JSONArray input;
        JSONObject properties;
        String afterActionModel;
        String beforeActionModel;
        int i;
        int n;
        JSONArray jsonArray;
        String action;
        String actionModel;
        String returnType;
        String intentPrompt;
        String actionPrompt;
        String name;
        Boolean export = jsonObject.getBoolean(EXPORT);
        if (export != null) {
            tool.setExport(export);
        }
        if ((name = jsonObject.getString(NAME)) != null) {
            tool.setName(name);
        }
        if ((actionPrompt = ToolImpl.getPromptString(jsonObject, tool instanceof Agent ? "system_prompt" : ACTION_PROMPT)) != null) {
            tool.setActionPrompt(actionPrompt);
        }
        if ((intentPrompt = ToolImpl.getPromptString(jsonObject, INTENT_PROMPT)) != null) {
            tool.setIntentPrompt(intentPrompt);
        }
        if ((returnType = jsonObject.getString(RETURN_TYPE)) != null) {
            tool.setReturnType(ReturnType.of(returnType));
        }
        if ((actionModel = jsonObject.getString(ACTION_MODEL)) != null) {
            tool.setActionModel(ActionModel.of(actionModel));
        }
        if ((action = jsonObject.getString(ACTION)) != null) {
            tool.setAction(action);
        }
        if ((jsonArray = jsonObject.getJSONArray(BEFORE_ACTION_TOOLS)) != null) {
            List<String> beforeActionTools = tool.getBeforeActionTools();
            beforeActionTools.clear();
            n = jsonArray.size();
            for (i = 0; i < n; ++i) {
                beforeActionTools.add(jsonArray.getString(i));
            }
        }
        if ((jsonArray = jsonObject.getJSONArray(AFTER_ACTION_TOOLS)) != null) {
            List<String> afterActionTools = tool.getAfterActionTools();
            afterActionTools.clear();
            n = jsonArray.size();
            for (i = 0; i < n; ++i) {
                afterActionTools.add(jsonArray.getString(i));
            }
        }
        if ((beforeActionModel = jsonObject.getString(BEFORE_ACTION_MODEL)) != null) {
            tool.setBeforeActionModel(BeforeOrAfterActionModel.of(beforeActionModel));
        }
        if ((afterActionModel = jsonObject.getString(AFTER_ACTION_MODEL)) != null) {
            tool.setAfterActionModel(BeforeOrAfterActionModel.of(afterActionModel));
        }
        if ((properties = jsonObject.getJSONObject(PROPERTIES)) != null) {
            tool.getProperties().putAll((Map<String, Object>)properties);
        }
        if ((input = jsonObject.getJSONArray(INPUT)) != null) {
            Map<String, String> inputs = tool.getInput();
            int n2 = input.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ToolInput ti = ToolInput.from(input.getJSONObject(i2));
                inputs.put(ti.getName(), ti.getRef());
            }
        }
        if ((params = jsonObject.getJSONArray(PARAMETERS)) != null) {
            int N = params.size();
            HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>(N);
            for (Parameter parameter : tool.getParameters()) {
                parameterMap.put(parameter.getName(), parameter);
            }
            for (int i3 = 0; i3 < N; ++i3) {
                JSONObject p = params.getJSONObject(i3);
                String parameterName = p.getString(NAME);
                Parameter parameter = (Parameter)parameterMap.get(parameterName);
                if (parameter == null) {
                    parameter = new Parameter();
                    tool.getParameters().add(parameter);
                }
                Parameter.merge(p, parameter);
            }
        }
    }

    private static String getPromptString(JSONObject jsonObject, String name) {
        Object o = jsonObject.get((Object)name);
        if (o instanceof JSONArray) {
            StringBuilder sb = new StringBuilder(64);
            JSONArray array = (JSONArray)o;
            int n = array.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(array.get(i));
            }
            return sb.toString();
        }
        return o == null ? null : String.valueOf(o);
    }

    ToolImpl() {
        this.setReturnType(ReturnType.AUTO);
        this.setActionModel(ActionModel.REACT);
        this.setBeforeActionModel(BeforeOrAfterActionModel.FLOW);
        this.setAfterActionModel(BeforeOrAfterActionModel.FLOW);
        this.setExport(true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getActionPrompt() {
        return this.actionPrompt;
    }

    @Override
    public void setActionPrompt(String actionPrompt) {
        this.actionPrompt = actionPrompt;
    }

    @Override
    public String getIntentPrompt() {
        return this.intentPrompt;
    }

    @Override
    public void setIntentPrompt(String intentPrompt) {
        this.intentPrompt = intentPrompt;
    }

    @Override
    public ReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public final void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String[] getParameterNames() {
        List<Parameter> parameters = this.getParameters();
        String[] names = new String[parameters.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = parameters.get(i).getName();
        }
        return names;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, String> getInput() {
        return this.input;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getActionExpression(AgentContext ctx) {
        if (this.action == null) {
            return null;
        }
        return Prompt.builder().add(this.action).build(ctx.getContextVarProvider()).getContent();
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public ActionModel getActionModel() {
        return this.actionModel;
    }

    @Override
    public final void setActionModel(ActionModel actionModel) {
        this.actionModel = actionModel;
    }

    @Override
    public boolean isExport() {
        return this.export;
    }

    @Override
    public final void setExport(boolean export) {
        this.export = export;
    }

    @Override
    public List<String> getBeforeActionTools() {
        return this.beforeActionTools;
    }

    @Override
    public List<String> getAfterActionTools() {
        return this.afterActionTools;
    }

    @Override
    public BeforeOrAfterActionModel getBeforeActionModel() {
        return this.beforeActionModel;
    }

    @Override
    public final void setBeforeActionModel(BeforeOrAfterActionModel beforeActionModel) {
        this.beforeActionModel = beforeActionModel;
    }

    @Override
    public BeforeOrAfterActionModel getAfterActionModel() {
        return this.afterActionModel;
    }

    @Override
    public final void setAfterActionModel(BeforeOrAfterActionModel afterActionModel) {
        this.afterActionModel = afterActionModel;
    }

    @Override
    public String genActionPrompt(InvokeData data, VarProvider contextVarProvider) {
        String actionPrompt = this.getActionPrompt();
        if (StringUtil.isEmpty(actionPrompt)) {
            if (data.isSingleValue()) {
                return String.valueOf(data.getSingleValue());
            }
            StringBuilder prompt = new StringBuilder();
            int i = 0;
            Map<String, Object> all = data.getAll();
            for (Map.Entry<String, Object> item : all.entrySet()) {
                if (i > 0) {
                    prompt.append(',');
                }
                prompt.append(item.getKey()).append(':').append(item.getValue());
                ++i;
            }
            return prompt.toString();
        }
        List<Parameter> parameterList = this.getParameters();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        if (data.isSingleValue()) {
            if (this.getInput().isEmpty() && parameterList.size() == 1) {
                varMap.put(parameterList.get(0).getName(), data.getSingleValue());
            }
        } else {
            Map<String, Object> all = data.getAll();
            for (Parameter parameter : parameterList) {
                String name = parameter.getName();
                if (!all.containsKey(name)) continue;
                varMap.put(name, all.get(name));
            }
        }
        PromptBuilder pb = new PromptBuilder();
        pb.add(actionPrompt);
        VarProvider provider = varMap.isEmpty() ? contextVarProvider : new MixedVarProvider(new MapVarProvider(varMap), contextVarProvider);
        return pb.build(provider).getContent();
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> mm = new LinkedHashMap<String, Object>();
        mm.put(NAME, this.getName());
        mm.put(EXPORT, this.isExport());
        mm.put(INTENT_PROMPT, this.getPromptForToMap(this.getIntentPrompt()));
        mm.put(ACTION_PROMPT, this.getPromptForToMap(this.getActionPrompt()));
        mm.put(ACTION_MODEL, this.getActionModel().name());
        mm.put(ACTION, this.getAction());
        mm.put(INPUT, this.getInput());
        ArrayList<Map<String, Object>> ps = new ArrayList<Map<String, Object>>(this.parameters.size());
        for (Parameter p : this.getParameters()) {
            ps.add(p.toMap());
        }
        mm.put(PARAMETERS, ps);
        mm.put(RETURN_TYPE, (Object)this.getReturnType());
        mm.put(BEFORE_ACTION_TOOLS, this.getBeforeActionTools());
        mm.put(BEFORE_ACTION_MODEL, this.getBeforeActionModel().name());
        mm.put(AFTER_ACTION_TOOLS, this.getAfterActionTools());
        mm.put(AFTER_ACTION_MODEL, this.getAfterActionModel().name());
        mm.put(PROPERTIES, this.getProperties());
        return mm;
    }

    protected Object getPromptForToMap(String prompt) {
        if (prompt == null || prompt.isEmpty()) {
            return prompt;
        }
        String[] strings = prompt.split("\n");
        if (strings.length == 1) {
            return prompt;
        }
        return Arrays.asList(strings);
    }

    public String toString() {
        return this.name;
    }
}

