/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.AgentContextImpl;
import kd.bos.gptas.autoact.exception.OutputParseException;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.ActionType;
import kd.bos.gptas.autoact.model.TaskAction;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.output.MultiOutputParser;
import kd.bos.gptas.autoact.output.OutputParser;
import kd.bos.gptas.autoact.output.ReturnType;
import kd.bos.gptas.autoact.output.parser.BooleanParser;
import kd.bos.gptas.autoact.output.parser.DateParser;
import kd.bos.gptas.autoact.output.parser.EnumParser;
import kd.bos.gptas.autoact.output.parser.ExecJavaScriptParser;
import kd.bos.gptas.autoact.output.parser.ExecKingScriptParser;
import kd.bos.gptas.autoact.output.parser.ExecTypeScriptParser;
import kd.bos.gptas.autoact.output.parser.ListParser;
import kd.bos.gptas.autoact.output.parser.MapParser;
import kd.bos.gptas.autoact.output.parser.NumberParser;
import kd.bos.gptas.autoact.output.parser.POJOParser;
import kd.bos.gptas.autoact.output.parser.RefinedTaskParser;
import kd.bos.gptas.autoact.output.parser.SearchKeyParser;
import kd.bos.gptas.autoact.output.parser.SetParser;
import kd.bos.gptas.autoact.output.parser.StringParser;
import kd.bos.gptas.autoact.output.parser.VoidParser;

public final class OutputParserFactory {
    public static OutputParser createParser(Class<?> returnType, Tool tool, AgentContext ctx) {
        return OutputParserFactory.doCreateParser(returnType, tool, ctx, true);
    }

    private static OutputParser doCreateParser(Class<?> returnType, Tool tool, AgentContext ctx, boolean allowMulti) {
        if (tool != null) {
            Action action;
            if (allowMulti && (action = ((AgentContextImpl)ctx).getExecutor().getToolAction(tool)) != null) {
                ActionType actionType = action.getActionType();
                switch (actionType) {
                    case SCRIPT: {
                        ExecKingScriptParser second = new ExecKingScriptParser(returnType, ctx);
                        OutputParser first = OutputParserFactory.doCreateParser(returnType, tool, ctx, false);
                        return new MultiOutputParser(first, second);
                    }
                    case KNOWLEDGE: {
                        if (returnType != null && returnType != String.class && !returnType.isAssignableFrom(MessageStream.class)) break;
                        return StringParser.INSTANCE;
                    }
                    case SEARCHER: {
                        SearchKeyParser second = new SearchKeyParser(ctx.getChatModel());
                        OutputParser first = OutputParserFactory.doCreateParser(returnType, tool, ctx, false);
                        return new MultiOutputParser(first, second);
                    }
                    case TASK: {
                        return new RefinedTaskParser(ctx.getChatModel());
                    }
                }
            }
            ReturnType rt = tool.getReturnType();
            switch (rt) {
                case AUTO: {
                    break;
                }
                case VOID: {
                    return VoidParser.INSTANCE;
                }
                case LIST: {
                    return ListParser.INSTANCE;
                }
                case SET: {
                    return SetParser.INSTANCE;
                }
                case MAP: {
                    return MapParser.INSTANCE;
                }
                case STRING: {
                    return StringParser.INSTANCE;
                }
                case BOOLEAN: {
                    return BooleanParser.INSTANCE;
                }
                case NUMBER: {
                    return NumberParser.INSTANCE;
                }
                case DATE: {
                    return DateParser.INSTANCE;
                }
                case OBJECT: {
                    return new POJOParser(returnType);
                }
                case JAVASCRIPT: {
                    return new ExecJavaScriptParser(returnType, ctx);
                }
                case TYPESCRIPT: {
                    return new ExecTypeScriptParser(returnType, ctx);
                }
                case KINGSCRIPT: {
                    return new ExecKingScriptParser(returnType, ctx);
                }
                case REFINED_TASK: {
                    return new RefinedTaskParser(ctx.getChatModel());
                }
                default: {
                    throw new OutputParseException("Undefined  tool-output-parser " + tool.getName() + " for return type: " + rt.name());
                }
            }
        }
        if (returnType == Void.TYPE) {
            return VoidParser.INSTANCE;
        }
        if (returnType == null || returnType == String.class) {
            return StringParser.INSTANCE;
        }
        if (List.class.isAssignableFrom(returnType)) {
            return ListParser.INSTANCE;
        }
        if (Set.class.isAssignableFrom(returnType)) {
            return SetParser.INSTANCE;
        }
        if (Map.class.isAssignableFrom(returnType)) {
            return MapParser.INSTANCE;
        }
        if (returnType.isEnum()) {
            return new EnumParser(returnType);
        }
        if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            return BooleanParser.INSTANCE;
        }
        if (Number.class.isAssignableFrom(returnType)) {
            return NumberParser.INSTANCE;
        }
        if (Date.class.isAssignableFrom(returnType)) {
            return DateParser.INSTANCE;
        }
        if (TaskAction.class.isAssignableFrom(returnType)) {
            return new RefinedTaskParser(ctx.getChatModel());
        }
        return new POJOParser(returnType);
    }
}

