/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.gptas.autoact.message.MessageStream;

public enum ReturnType {
    AUTO,
    VOID,
    OBJECT,
    LIST,
    SET,
    MAP,
    STRING,
    NUMBER,
    BOOLEAN,
    DATE,
    JAVASCRIPT,
    TYPESCRIPT,
    KINGSCRIPT,
    REFINED_TASK;


    public static ReturnType of(String returnType) {
        if (returnType == null) {
            return AUTO;
        }
        return ReturnType.valueOf(returnType.toUpperCase());
    }

    public static ReturnType from(Class<?> cls) {
        if (cls == Void.TYPE) {
            return VOID;
        }
        if (cls == String.class || MessageStream.class.isAssignableFrom(cls)) {
            return STRING;
        }
        if (Number.class.isAssignableFrom(cls) || cls == Short.TYPE || cls == Integer.TYPE || cls == Float.TYPE || cls == Double.TYPE || cls == Long.TYPE) {
            return NUMBER;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return DATE;
        }
        if (List.class.isAssignableFrom(cls)) {
            return LIST;
        }
        if (Set.class.isAssignableFrom(cls)) {
            return SET;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return MAP;
        }
        return OBJECT;
    }
}

