/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.convert;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.output.convert.InvokeDataType;
import kd.bos.gptas.autoact.output.convert.ObjectConverter;
import kd.bos.gptas.autoact.output.parser.POJOParser;
import kd.bos.gptas.autoact.prompt.Prompt;

public class LLMConverter
implements Logable {
    public static <T> T convert(Object value, Class<T> toType, AgentContext ctx) {
        try {
            return ObjectConverter.convert(value, toType);
        }
        catch (ClassCastException e) {
            boolean loggable;
            String dataDescription = InvokeDataType.isSingleValue(value, false) ? "```html\n" + InvokeDataType.singleValueToString(value) : "```json\n" + JSONObject.toJSONString((Object)value);
            POJOParser<T> parser = new POJOParser<T>(toType);
            String prompt = Prompt.builder().add(dataDescription + "\n```\n").add(parser.outputFormatPrompt(ctx.getChatModel().name())).build(Collections.emptyMap()).getContent();
            boolean bl = loggable = ctx.isVerbose() && logger.isInfoEnabled();
            if (loggable) {
                logger.info("[CONVERTING]" + prompt + "\n-->" + toType.getName());
            }
            String text = ctx.getChatModel().generate(prompt).getResult().getMessage();
            if (loggable) {
                logger.info("[CONVERTED]" + text);
            }
            return parser.parse(text);
        }
    }
}

