/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.output.parser;

import com.alibaba.fastjson.JSONObject;
import kd.bos.gptas.autoact.exception.NoScriptCodeBlockException;
import kd.bos.gptas.autoact.util.JsonUtil;

public class CodeBlockExtractor {
    private static final String CODE_BLOCK = "```";

    public static String extractFirst(String language, String text) {
        if (!text.contains(CODE_BLOCK)) {
            throw new NoScriptCodeBlockException("No " + language + " blocks found: " + text);
        }
        int p = text.indexOf(CODE_BLOCK + language);
        if (p == -1) {
            try {
                String json = CodeBlockExtractor.extractFirst("json", text);
                JSONObject jsonObject = JsonUtil.parseObject(json);
                return jsonObject.getString("code");
            }
            catch (NoScriptCodeBlockException json) {
                throw new NoScriptCodeBlockException("No " + language + " blocks found: " + text);
            }
        }
        String code = text.substring(p + (CODE_BLOCK + language).length());
        if ((p = code.indexOf(CODE_BLOCK)) != -1) {
            code = code.substring(0, p);
        }
        if (code.charAt(0) == '\n') {
            code = code.substring(1);
        }
        if (code.charAt(code.length() - 1) == '\n') {
            code = code.substring(0, code.length() - 1);
        }
        return code;
    }
}

