/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.prompt;

import java.util.HashMap;
import java.util.Map;
import kd.bos.gptas.autoact.exception.GetVarExpressionException;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.prompt.PromptBuilder;
import kd.bos.gptas.autoact.prompt.loader.PromptLoader;
import kd.bos.gptas.autoact.prompt.var.MapVarProvider;
import kd.bos.gptas.autoact.prompt.var.VarProvider;

public final class Prompt {
    private final String template;
    private final VarProvider varProvider;

    public static PromptBuilder builder() {
        return new PromptBuilder();
    }

    public static Prompt load(String promptPath, VarProvider varProvider, ChatModel chatModel) {
        String template = PromptLoader.get().loadAlternative(promptPath, chatModel.name());
        return new Prompt(template, varProvider);
    }

    public Prompt(String template) {
        this(template, new HashMap<String, Object>());
    }

    public Prompt(String template, Map<String, Object> varMap) {
        this.template = template;
        this.varProvider = new MapVarProvider(varMap);
    }

    public Prompt(String template, VarProvider varProvider) {
        this.template = template;
        this.varProvider = varProvider;
    }

    public VarProvider getVarProvider() {
        return this.varProvider;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getContent() {
        VarProvider currentVarProvider;
        VarProvider varProvider = currentVarProvider = this.varProvider == null ? MapVarProvider.EMPTY : this.varProvider;
        if (currentVarProvider.isEmpty() && !this.template.contains("{{")) {
            return this.template;
        }
        StringBuilder sb = new StringBuilder(this.template.length() + 128);
        char[] chs = this.template.toCharArray();
        int N = chs.length;
        boolean varBegan = false;
        StringBuilder varName = new StringBuilder(32);
        for (int i = 0; i < N; ++i) {
            char ch = chs[i];
            if (ch == '{' && i + 1 < N && chs[i + 1] == '{') {
                varBegan = true;
                varName.setLength(0);
                ++i;
                continue;
            }
            if (varBegan && ch == '}' && i + 1 < N && chs[i + 1] == '}') {
                varBegan = false;
                if (varName.length() > 0) {
                    String name = varName.toString();
                    String defaultValue = null;
                    int p = name.indexOf(61);
                    if (p != -1) {
                        defaultValue = name.substring(p + 1).trim();
                        name = name.substring(0, p).trim();
                    }
                    try {
                        Object value = currentVarProvider.getByExpression(name);
                        if (value == null) {
                            value = defaultValue;
                        }
                        sb.append(value);
                    }
                    catch (GetVarExpressionException e) {
                        if (defaultValue != null) {
                            sb.append(defaultValue);
                        }
                        sb.append("{{").append((CharSequence)varName).append("}}");
                    }
                    varName.setLength(0);
                } else {
                    sb.append("}}");
                }
                ++i;
                continue;
            }
            if (varBegan) {
                varName.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getContent();
    }
}

