/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.prompt.var;

import java.util.HashMap;
import java.util.Map;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.model.Parameter;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.autoact.prompt.var.MapVarProvider;
import kd.bos.gptas.autoact.prompt.var.MixedVarProvider;
import kd.bos.gptas.autoact.prompt.var.VarProvider;

public final class ContextVarProvider
extends MixedVarProvider {
    private final MapVarProvider toolPrivateInputVar;
    private final MapVarProvider toolGlobalAllVar;
    private final MapVarProvider toolPrivatePropertiesVar;
    private final MapVarProvider agentGlobalPropertiesVar;
    private AgentContext ctx;

    public ContextVarProvider(VarProvider agentGlobalVar, AgentContext ctx) {
        super(new MapVarProvider(new HashMap<String, Object>()), new MapVarProvider(new HashMap<String, Object>()), agentGlobalVar, new MapVarProvider(new HashMap<String, Object>()), new MapVarProvider(new HashMap<String, Object>()));
        this.toolPrivateInputVar = (MapVarProvider)this.providers[0];
        this.toolGlobalAllVar = (MapVarProvider)this.providers[1];
        this.toolPrivatePropertiesVar = (MapVarProvider)this.providers[3];
        this.agentGlobalPropertiesVar = (MapVarProvider)this.providers[4];
        this.ctx = ctx;
    }

    public Object getInput() {
        return this.toolGlobalAllVar.get("__input__");
    }

    public void setInput(Object input) {
        this.agentGlobalPropertiesVar.setAll(this.ctx.getAgent().getProperties());
        this.toolGlobalAllVar.set("__input__", input);
    }

    public Object getOutput() {
        return this.toolGlobalAllVar.get("__output__");
    }

    public void setOutput(Object output) {
        this.toolGlobalAllVar.set("__output__", output);
    }

    public Object getToolInput(Tool tool) {
        return this.toolGlobalAllVar.get(tool.getName() + '.' + "__input__");
    }

    public void setToolInput(Tool tool, Object input) {
        Map<String, Object> properties = tool.getProperties();
        if (!properties.isEmpty()) {
            this.toolPrivatePropertiesVar.setAll(properties);
            for (Map.Entry<String, Object> item : properties.entrySet()) {
                this.toolGlobalAllVar.set(tool.getName() + '.' + item.getKey(), item.getValue());
            }
        }
        this.toolGlobalAllVar.set(tool.getName() + '.' + "__input__", input);
        Map<String, String> inputs = tool.getInput();
        for (Parameter parameter : tool.getParameters()) {
            String name = parameter.getName();
            String ref = inputs.get(name);
            if (ref == null) continue;
            Object value = this.getByExpression(ref);
            this.toolGlobalAllVar.set(tool.getName() + '.' + name, value);
            this.toolPrivateInputVar.set(name, value);
        }
    }

    public Object getToolOutput(Tool tool) {
        return this.toolGlobalAllVar.get(tool.getName());
    }

    public void setToolOutput(Tool tool, Object output) {
        this.toolGlobalAllVar.set(tool.getName(), output);
        this.toolPrivateInputVar.clear();
        this.toolPrivatePropertiesVar.clear();
    }
}

