/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.tools.javascript;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.def.ToolAction;
import kd.bos.gptas.autoact.exception.ExecuteScriptException;
import kd.bos.gptas.autoact.model.Action;
import kd.bos.gptas.autoact.model.ActionType;
import kd.bos.gptas.autoact.output.convert.LLMConverter;
import kd.bos.gptas.autoact.tools.javascript.JavaScriptConsole;

public class JavaScriptExecutionAction<R>
implements Action<R, String> {
    private Class<?> returnType;
    private AgentContext ctx;
    private static final JavaScriptConsole console = new JavaScriptConsole();

    public JavaScriptExecutionAction(Class<?> returnType, AgentContext ctx) {
        this.returnType = returnType;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.SCRIPT;
    }

    @Override
    @ToolAction
    public R act(String script) {
        ScriptEngine engine = this.createSecureScriptEngine();
        try {
            engine.put("console", console);
            engine.eval(script);
            Object result = engine.get("__result");
            result = this.getHostValue(result);
            result = LLMConverter.convert(result, this.returnType, this.ctx);
            return (R)result;
        }
        catch (ScriptException e) {
            throw new ExecuteScriptException("Execute javascript error: " + script, e);
        }
    }

    private ScriptEngine createSecureScriptEngine() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        Bindings bindings = engine.getBindings(100);
        bindings.put("Java", (Object)null);
        return engine;
    }

    private Object getHostValue(Object o) {
        if (o instanceof ScriptObjectMirror) {
            ScriptObjectMirror mirror = (ScriptObjectMirror)o;
            if (mirror.isFunction()) {
                return o.toString();
            }
            if (mirror.isArray()) {
                return mirror.values().stream().map(e -> this.getHostValue(e)).collect(Collectors.toList());
            }
            if (this.returnType != null && this.returnType.isAssignableFrom(Date.class)) {
                return ((ScriptObjectMirror)o).callMember("getTime", new Object[0]);
            }
            return mirror.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getHostValue(e.getValue())));
        }
        return o;
    }
}

