/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public final class SPILoader {
    private SPILoader() {
    }

    public static <T> List<T> load(Class<T> spiCls) throws IllegalArgumentException {
        return SPILoader.load(spiCls, false);
    }

    public static <T> T loadSingle(Class<T> spiCls) throws IllegalArgumentException {
        List<T> list = SPILoader.load(spiCls, true);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    private static <T> List<T> load(Class<T> spiCls, boolean single) {
        ArrayList<T> ret = new ArrayList<T>();
        ServiceLoader<T> sl = ServiceLoader.load(spiCls);
        Iterator<T> iter = sl.iterator();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        if (single && ret.size() > 1) {
            throw new IllegalArgumentException("Found multi-spi implements: " + spiCls.getName() + "->" + ret);
        }
        return Collections.unmodifiableList(ret);
    }
}

