/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.autoact.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class SPISingletonLoader {
    private static Map<Class<?>, List<Object>> singleStonMap = new ConcurrentHashMap();
    private static Map<Class<?>, Object> singleStonLockMap = new ConcurrentHashMap();

    private SPISingletonLoader() {
    }

    public static <T> List<T> load(Class<T> spiCls) throws IllegalArgumentException {
        return SPISingletonLoader.load(spiCls, false);
    }

    public static <T> T loadSingle(Class<T> spiCls) throws IllegalArgumentException {
        List<T> list = SPISingletonLoader.load(spiCls, true);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> load(Class<T> spiCls, boolean single) {
        List<Object> ret = singleStonMap.get(spiCls);
        if (ret == null) {
            Object lock;
            Object object = lock = singleStonLockMap.computeIfAbsent(spiCls, cls -> new Object());
            synchronized (object) {
                ret = new ArrayList<Object>();
                ServiceLoader<T> sl = ServiceLoader.load(spiCls);
                Iterator<T> iter = sl.iterator();
                while (iter.hasNext()) {
                    ret.add(iter.next());
                }
                singleStonLockMap.put(spiCls, ret);
            }
        }
        if (single && ret.size() > 1) {
            throw new IllegalArgumentException("Found multi-spi implements: " + spiCls.getName() + "->" + ret);
        }
        return Collections.unmodifiableList(ret);
    }
}

