/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.minio.minioclient;

import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.io.IOUtils;

@SdkInternal
public class BosMinIOClient {
    private static String MINIO_TEMP_RETAIN = "minio.temp.retain";
    private static String MINIO_LOG_ENABLE = "minio.log.enable";
    private static Log logger = LogFactory.getLog(BosMinIOClient.class);
    private MinioClient minioClient;
    private String minioServerUrl;
    private static ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);

    public BosMinIOClient(FileStorageConfig fileStorageConfig) {
        this.minioServerUrl = fileStorageConfig.getFileServerHttpUrl();
        try {
            this.validFileStorageConfig(fileStorageConfig);
            this.minioClient = this.createMinioClient(fileStorageConfig);
        }
        catch (Exception e) {
            logger.error("Error occurred while creating minioClient: " + e.getMessage(), (Throwable)e);
        }
    }

    private void validFileStorageConfig(FileStorageConfig config) throws KDException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("fileServerHttpUrl", config.getFileServerHttpUrl());
        properties.put("authUserName", config.getAuthUserName());
        ArrayList errorMsgs = new ArrayList();
        properties.forEach((property, value) -> {
            if (StringUtils.isEmpty((String)value)) {
                errorMsgs.add(property + " is empty!");
            }
        });
        if (!errorMsgs.isEmpty()) {
            String errorMsg = String.join((CharSequence)" ", errorMsgs);
            logger.error(errorMsg);
            throw new KDException((Throwable)new Exception(), BosErrorCode.minioInitError, new Object[]{errorMsg});
        }
    }

    private MinioClient createMinioClient(FileStorageConfig fileStorageConfig) {
        String serverUrl = fileStorageConfig.getFileServerHttpUrl();
        String userName = fileStorageConfig.getAuthUserName();
        if (BosMinIOClient.needLog()) {
            logger.info("serverUrl:" + serverUrl + ", userName:" + userName);
        }
        return MinioClient.builder().endpoint(fileStorageConfig.getFileServerHttpUrl()).credentials(fileStorageConfig.getAuthUserName(), fileStorageConfig.getAuthPassword()).build();
    }

    public List<Bucket> getAllBuckets() throws InvalidKeyException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidResponseException, NoSuchAlgorithmException, ServerException, XmlParserException, IOException {
        if (BosMinIOClient.needLog()) {
            logger.info("list all buckets, minioServerUrl:{}", (Object)this.minioServerUrl);
        }
        return this.minioClient.listBuckets();
    }

    public void upload(String bucketName, String fileName, String filePath) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        if (BosMinIOClient.needLog()) {
            logger.info("upload file by filePath: {}, bucketName: {}, fileName: {}, minioServerUrl:{}", new Object[]{filePath, bucketName, fileName, this.minioServerUrl});
        }
        try {
            this.checkBucket(bucketName);
            this.minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(fileName)).filename(filePath).build());
        }
        catch (Exception e) {
            logger.error("Error occurred while uploading file", (Throwable)e);
            throw e;
        }
    }

    public void upload(String bucketName, String fileName, InputStream inputStream, Map<String, String> headers) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        if (BosMinIOClient.needLog()) {
            logger.info("upload file by inputStream, bucketName: {}, fileName: {}, minioServerUrl:{}", new Object[]{bucketName, fileName, this.minioServerUrl});
        }
        Path tempFilePath = null;
        try {
            this.checkBucket(bucketName);
            tempFilePath = this.getTempBin(inputStream, fileName);
            inputStream = new FileInputStream(tempFilePath.toFile());
            PutObjectArgs build = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(inputStream, (long)inputStream.available(), -1L).extraHeaders(headers)).build();
            this.minioClient.putObject(build);
        }
        catch (Exception e) {
            logger.error("Error occurred while uploading file", (Throwable)e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            if (tempFilePath != null && tempFilePath.toFile().exists() && !Boolean.getBoolean(MINIO_TEMP_RETAIN)) {
                tempFilePath.toFile().delete();
            }
        }
    }

    public Path getTempBin(InputStream inputStream, String originFileName) throws IOException {
        String fileExtension = originFileName.substring(originFileName.lastIndexOf("."));
        String tempFileName = "tempfile-" + System.currentTimeMillis();
        Path path = Files.createTempFile(tempFileName, fileExtension, new FileAttribute[0]);
        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        IOUtils.closeQuietly((InputStream)inputStream);
        if (BosMinIOClient.needLog()) {
            logger.info("Original file: {} ,temp file: {}", (Object)originFileName, (Object)path.toString());
        }
        return path;
    }

    public void download(String bucketName, String fileName, OutputStream out) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        if (BosMinIOClient.needLog()) {
            logger.info("download form minio:{}, bucketName:{}, fileName: {}", new Object[]{this.minioServerUrl, bucketName, fileName});
        }
        GetObjectResponse input = null;
        try {
            input = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        catch (Exception e) {
            try {
                logger.error("Error occurred while downloading file - bucket: {}, fileName: {}", new Object[]{bucketName, fileName, e});
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    public InputStream getInputStream(String bucketName, String fileName) throws InvalidKeyException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidResponseException, NoSuchAlgorithmException, ServerException, XmlParserException, IOException {
        if (BosMinIOClient.needLog()) {
            logger.info("getInputStream form minio:{}, bucketName:{}, fileName: {}", new Object[]{this.minioServerUrl, bucketName, fileName});
        }
        return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
    }

    public void deleteFile(String bucketName, String fileName) throws InvalidKeyException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidResponseException, NoSuchAlgorithmException, ServerException, XmlParserException, IOException {
        if (BosMinIOClient.needLog()) {
            logger.info("deleteFile from minio:{}, bucketName:{}, fileName: {}", new Object[]{this.minioServerUrl, bucketName, fileName});
        }
        this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
        if (BosMinIOClient.needLog()) {
            logger.info("deleteFile success, bucketName:{}, fileName: {}", (Object)bucketName, (Object)fileName);
        }
    }

    public boolean isFileExists(String bucketName, String objectName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        if (BosMinIOClient.needLog()) {
            logger.info("isFileExists minio:{}, bucketName:{}, objectName: {}", new Object[]{this.minioServerUrl, bucketName, objectName});
        }
        StatObjectResponse sObjectStat = null;
        try {
            sObjectStat = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (ErrorResponseException e) {
            if (StringUtils.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("Object does not exist")) {
                logger.info("BucketName: {}, objectName: {}, doesn't exist", (Object)bucketName, (Object)objectName);
                return false;
            }
            throw e;
        }
        return sObjectStat != null;
    }

    private void checkBucket(String bucketName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        boolean isExist = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        if (!isExist) {
            String errorMsg = "Bucket: " + bucketName + " not exist";
            logger.error(errorMsg);
            throw new KDException(BosErrorCode.minioBucketNotExist, new Object[]{errorMsg});
        }
    }

    public long getFileSize(String bucketName, String fileName) throws ServerException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException {
        StatObjectResponse sObjectStat = null;
        sObjectStat = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
        return sObjectStat.size();
    }

    public String getFileUrl(String bucketName, String fileName) throws InvalidKeyException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidResponseException, NoSuchAlgorithmException, XmlParserException, ServerException, IOException {
        if (BosMinIOClient.needLog()) {
            logger.info("getFileUrl minio:{}, bucketName:{}, fileName:{}", new Object[]{this.minioServerUrl, bucketName, fileName});
        }
        return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).build());
    }

    private static boolean needLog() {
        return Boolean.getBoolean(MINIO_LOG_ENABLE);
    }
}

