/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.config;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.kdtx.common.constant.InvokeType;

public class DtxConfig {
    public static int getTxDispatchServiceTimeout() {
        return Integer.getInteger("kdtx.txDispatchService.timeout", 300000);
    }

    public static int getTxDispatchServiceRetries() {
        return Integer.getInteger("kdtx.txDispatchService.retries", 0);
    }

    public static int getBranchDispatchServiceTimeout() {
        return Integer.getInteger("kdtx.branchDispatchService.timeout", 180000);
    }

    public static int getBranchDispatchServiceRetries() {
        return Integer.getInteger("kdtx.branchDispatchService.retries", 0);
    }

    public static int getTxBeginTimeout() {
        return Integer.getInteger("kdtx.txBegin.timeout", 30000);
    }

    public static int getTxBeginRetries() {
        return Integer.getInteger("kdtx.txBegin.retries", 0);
    }

    public static int getTxBeginLocalRetries() {
        return Integer.getInteger("kdtx.txBegin.local.retries", 1);
    }

    public static int getTxCommitTimeout() {
        return Integer.getInteger("kdtx.txCommit.timeout", 120000);
    }

    public static int getTxCommitRetries() {
        return Integer.getInteger("kdtx.txCommit.retries", 1);
    }

    public static int getTxCommitLocalRetries() {
        return Integer.getInteger("kdtx.txCommit.local.retries", 1);
    }

    public static int getTxRollbackTimeout() {
        return Integer.getInteger("kdtx.txRollback.timeout", 120000);
    }

    public static int getTxRollbackRetries() {
        return Integer.getInteger("kdtx.txRollback.retries", 1);
    }

    public static int getTxRollbackLocalRetries() {
        return Integer.getInteger("kdtx.txRollback.local.retries", 1);
    }

    public static int getBranchRegisterTimeout() {
        return Integer.getInteger("kdtx.branchRegister.timeout", 30000);
    }

    public static int getBranchRegisterRetries() {
        return Integer.getInteger("kdtx.branchRegister.retries", 1);
    }

    public static int getBranchRegisterLocalRetries() {
        return Integer.getInteger("kdtx.branchRegister.local.retries", 1);
    }

    public static int getBranchPrepareTimeout() {
        return Integer.getInteger("kdtx.branchPrepare.timeout", 540000);
    }

    public static int getBranchPrepareRetries() {
        return Integer.getInteger("kdtx.branchPrepare.retries", 3);
    }

    public static int getBranchPrepareLocalRetries() {
        return Integer.getInteger("kdtx.branchPrepare.local.retries", 0);
    }

    public static int getBranchCommitTimeout() {
        return Integer.getInteger("kdtx.branchCommit.timeout", 600000);
    }

    public static int getBranchCommitRetries() {
        return Integer.getInteger("kdtx.branchCommit.retries", 3);
    }

    public static int getBranchCommitLocalRetries() {
        return Integer.getInteger("kdtx.branchCommit.local.retries", 0);
    }

    public static int getBranchRollbackTimeout() {
        return Integer.getInteger("kdtx.branchRollback.timeout", 8000);
    }

    public static int getBranchRollbackRetries() {
        return Integer.getInteger("kdtx.branchRollback.retries", 3);
    }

    public static int getBranchRollbackLocalRetries() {
        return Integer.getInteger("kdtx.branchRollback.local.retries", 0);
    }

    public static int getBranchCompensateRetries() {
        return Integer.getInteger("kdtx.compensate.local.retries", 0);
    }

    public static boolean getBizTableAutoInit() {
        return Boolean.parseBoolean(System.getProperty("kdtx.biztable.autoinit", "true"));
    }

    public static boolean isAlarmMessageEnable() {
        return Boolean.parseBoolean(System.getProperty("kdtx.alarm.enable", "false"));
    }

    public static int getAlarmInterval() {
        return Integer.getInteger("kdtx.alarm.interval", 5);
    }

    public static int getAlarmIntervalTime() {
        return Integer.getInteger("kdtx.alarm.interval.time", 1800);
    }

    public static int getRetriesByType(InvokeType invokeType) {
        switch (invokeType) {
            case TX_BEGIN: 
            case BRANCH_REGISTER: {
                return DtxConfig.getBranchRegisterLocalRetries();
            }
            case TX_COMMIT: {
                return DtxConfig.getTxCommitRetries();
            }
            case TX_ROLLBACK: {
                return DtxConfig.getTxRollbackRetries();
            }
            case PREPARE: {
                return DtxConfig.getBranchPrepareLocalRetries();
            }
            case BRANCH_COMMIT: {
                return DtxConfig.getBranchCommitLocalRetries();
            }
            case BRANCH_ROLLBACK: {
                return DtxConfig.getBranchRollbackLocalRetries();
            }
            case MANUAL_COMPENSATE: {
                return DtxConfig.getBranchCompensateRetries();
            }
        }
        return 0;
    }

    public static boolean canRunMqMode(boolean sessionRunMq) {
        boolean allowMq = Boolean.parseBoolean(System.getProperty("kdtx.ec.mqmode", "false"));
        boolean tenantActive = false;
        RequestContext requestContext = RequestContext.get();
        String tenantId = null;
        if (requestContext != null) {
            tenantId = RequestContext.get().getTenantId();
        }
        String tenantIdConfig = System.getProperty("kdtx.ec.mqmode.tenantids", "");
        if (StringUtils.isEmpty((CharSequence)tenantId) || StringUtils.isEmpty((CharSequence)tenantIdConfig)) {
            tenantActive = true;
        } else {
            String[] tenantIds = tenantIdConfig.split(",");
            if (tenantIds.length > 0) {
                for (String t : tenantIds) {
                    if (!tenantId.equals(t)) continue;
                    tenantActive = true;
                    break;
                }
            }
        }
        return allowMq && tenantActive && sessionRunMq;
    }

    public static int getBranchConsumerConcurrency() {
        return Integer.getInteger("kdtx.branchConsumer.concurrency", 10);
    }

    public static int getCascadeLevel() {
        return Integer.getInteger("kdtx.branchRegister.cascade.level", 3);
    }

    public static int getTCCSaveDataLimit() {
        return Integer.getInteger("kdtx.tcc.saveData.limit", 1000);
    }

    public static long getMaxParamSize() {
        return Long.getLong("kdtx.branchRegister.paramsize", 0x3200000L);
    }
}

